package cn.com.duiba.credits.credits.center.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * @author author
 */
public class TrusteeshipCreditsRecordsDto implements Serializable {

    private static final long serialVersionUID = 1560416227712L;


    /**
     * 主键
     * <p>
     * isNullAble:0
     */
    private Long id;

    /**
     * appid
     * isNullAble:0
     */
    private Long appId;

    /**
     * 业务类型：加积分／扣积分（add／consume）
     * isNullAble:0
     */
    private String bizType;

    /**
     * 订单状态：待确认／已完成（process／finish）
     * isNullAble:0
     */
    private String orderStatus;

    /**
     * 订单信息（失败时响应失败信息）
     * isNullAble:1
     */
    private String message;

    /**
     * 用户id
     * isNullAble:0
     */
    private Long consumerId;

    /**
     * 兑吧订单号
     * isNullAble:0
     */
    private String orderNum;

    /**
     * 需要变动的积分数额
     * isNullAble:0
     */
    private Long credits;

    /**
     * 活动类型(加积分/扣积分的类目，范围不限定，会动态变化)
     * isNullAble:0
     */
    private String activityType;

    /**
     * 兑换项市场价格
     * isNullAble:1
     */
    private Long facePrice;

    /**
     * 兑换商品实际扣除（单位：分）
     * isNullAble:1
     */
    private Long actualPrice;

    /**
     * 用户ip地址
     * isNullAble:1
     */
    private String ip;

    /**
     * 是否待审核 0-不需要审核 1-待审核
     * isNullAble:1
     */
    private Integer waitAudit;

    /**
     * 额外业务参数
     * isNullAble:1
     */
    private String params;

    /**
     * 订单描述
     * isNullAble:1
     */
    private String description;

    /**
     * 创建时间
     * isNullAble:0,defaultVal:CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * isNullAble:0,defaultVal:CURRENT_TIMESTAMP
     */
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return this.appId;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public String getBizType() {
        return this.bizType;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getOrderStatus() {
        return this.orderStatus;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getConsumerId() {
        return this.consumerId;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getOrderNum() {
        return this.orderNum;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public Long getCredits() {
        return this.credits;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public void setFacePrice(Long facePrice) {
        this.facePrice = facePrice;
    }

    public Long getFacePrice() {
        return this.facePrice;
    }

    public void setActualPrice(Long actualPrice) {
        this.actualPrice = actualPrice;
    }

    public Long getActualPrice() {
        return this.actualPrice;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getIp() {
        return this.ip;
    }

    public void setWaitAudit(Integer waitAudit) {
        this.waitAudit = waitAudit;
    }

    public Integer getWaitAudit() {
        return this.waitAudit;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getParams() {
        return this.params;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return this.gmtModified;
    }
}
