package cn.com.duiba.credits.credits.center.api.param.dalian;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author fja
 */
public class DalianUnionQueryParam implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 兑吧用户id
     */
    private Long consumerId;
    /**
     * appId
     */
    private Long appId;
    /**
     * 增加：['ADD', 'VIRTUAL_EXCHANGE']
     * 扣减：['CONSUME']
     */
    private List<String> bizTypes;
    /**
     * 1:线下任务，0：线上任务
     */
    private Integer sourceType;
    /**
     * 页码
     */
    private Integer pageNum;
    /**
     * 每页数据条数
     */
    private Integer pageSize;
    /**
     * 分页偏移量
     */
    private Integer offset;
    /**
     * 开始时间
     */
    private Date startDate;
    /**
     * 结束时间
     */
    private Date endDate;


    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getOffset() {
        if (null != pageNum && null != pageSize) {
            return (pageNum - 1) * pageSize;
        }
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public List<String> getBizTypes() {
        return bizTypes;
    }

    public Integer getSourceType() {
        return sourceType;
    }
}
