package cn.com.duiba.credits.credits.center.api.remoteservice;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.credits.credits.center.api.dto.expire.ExpireTrusteeshipCreditsDto;
import cn.com.duiba.credits.credits.center.api.dto.expire.ExpireTrusteeshipCreditsRecordsDto;
import cn.com.duiba.credits.credits.center.api.param.expire.ExpireQueryConsumerParam;
import cn.com.duiba.credits.credits.center.api.param.expire.ExpireTrusteeshipCreditsRecordsParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteExpireTrusteeshipCreditsService {

    /**
     * 插入
     * 1.除非有必要,否者推荐使用RemoteTrusteeshipCreditsExpandService.increaseWithRecord
     * 改方法会自动插入流水表
     *
     * @param pojo
     * @return
     */
    Long insert(ExpireTrusteeshipCreditsDto pojo);

    /**
     * 修改,慎重调用
     * 1.一般不允许web调用修改数据.除了少数情况
     *
     * @param pojo
     * @return
     */
    int updateById(ExpireTrusteeshipCreditsDto pojo);

    ExpireTrusteeshipCreditsDto selectOne(Long appId, Long consumerId);

    ExpireTrusteeshipCreditsDto selectOneById(Long id);

    /**
     * 分页查询
     * @param pojo 查询条件
     * @return
     */
    Page<ExpireTrusteeshipCreditsDto> recordsPageList(ExpireQueryConsumerParam pojo);

    /**
     * 清理app下所有用户积分
     * @param appId
     * @param id
     */
    void clearCredits(Long appId, Long id);

    /**
     * 清理用户积分
     * @param appId
     * @param consumerId
     * @return
     */
    Long clearUserCredits(Long appId, Long consumerId) throws BizException;

    /**
     * 批量清理用户积分
     * @param appId
     * @param consumerIdList
     */
    void batchClearUserCredits(Long appId, List<Long> consumerIdList);
}
