package cn.com.duiba.customer.link.project.api.remoteservice.app81279.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.customer.link.project.api.remoteservice.app81279.dto.resultData.ZrysSavePrizeDataDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app81279.dto.result.ZyrsClientNoResultDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app81279.dto.result.ZyrsResultDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app81279.dto.resultData.ZyrsSaveClientDataDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app81279.dto.resultData.ZyrsSaveRecordDataDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app81279.dto.result.ZyrsTaskResultDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app81279.vo.ZyrsUserInfoVO;

/**
 * Description:
 * <p> 中意人寿三方服务
 * date: 2022/11/1 13:41
 *
 * @author huakai
 */
public interface RemoteZyrsService {
    /**
     * 保存访问记录
     * @param recordData 参与数据
     * @return data null 无意义
     * @throws BizException 业务异常
     */
    ZyrsResultDto saveJoinRecord(ZyrsSaveRecordDataDto recordData) throws BizException;

    /**
     * 保存客户信息
     * @param clientData 客户信息
     * @return data null 无意义
     * @throws BizException 业务异常
     */
    ZyrsResultDto saveUserMessage(ZyrsSaveClientDataDto clientData) throws BizException;

    /**
     * 保存中奖记录
     * @param prizeData 发奖数据
     * @return data null 无意义
     * @throws BizException 业务异常
     */
    ZyrsResultDto savePrizeRecord(ZrysSavePrizeDataDto prizeData) throws BizException;

    /**
     * 查询是否关注公众号
     * @param openId 用户openId
     * @return data  0 未关注 1 已关注
     * @throws BizException 业务异常
     */
    ZyrsResultDto isFocus(String openId) throws BizException;

    /**
     * 查询任务
     * @param clientNo 客户号
     * @return 任务信息
     * @throws BizException 业务异常
     */
    ZyrsTaskResultDto queryTask(String clientNo) throws BizException;

    /**
     * 查询客户号
     * @param mobile 手机号
     * @return 客户号
     * @throws BizException 业务异常
     */
    ZyrsClientNoResultDto getClientNo(String mobile) throws BizException;

    /**
     * 获取头像昵称
     * @return
     */
    ZyrsUserInfoVO getUserInfo(String openId);


}
