package cn.com.duiba.customer.link.project.api.remoteservice.app86760;

import cn.com.duiba.customer.link.project.api.remoteservice.app86760.dto.AddPointsAndPayOrderDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app86760.dto.GetProfitInfoDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app86760.dto.GetUserTotalAssetsDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app86760.vo.AddPointsAndPayOrderVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app86760.vo.GetProfitInfoVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app86760.vo.GetUserTotalAssetsVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app86760.vo.RecommendNewVO;

/**
 * 江苏银行接口调用
 *
 * @author xulei
 * @since 1.0.0
 */
public interface RemoteJiangSuBank {

    /**
     * 查询用户持有资产 <br>
     * Note: 接口请求异常(加解密异常, 网络异常等), 返回{@code null}
     *
     * @param dto 请求入参
     * @return 用户持有资产VO, 详见{@link GetUserTotalAssetsVO}
     */
    String getUserTotalAssets(GetUserTotalAssetsDTO dto);

    /**
     * 查询推荐基金产品接口 <br>
     * Note: 接口请求异常(加解密异常, 网络异常等), 返回{@code null}
     *
     * @return 推荐基金产品VO, 详见{@link RecommendNewVO}
     */
    String recommendNew();

    /**
     * 查询用户收益信息 <br>
     * Note: 接口请求异常(加解密异常, 网络异常等), 返回{@code null}
     *
     * @param dto 请求入参
     * @return 用户收益信息VO, 详见{@link GetProfitInfoVO}
     */
    String getProfitInfo(GetProfitInfoDTO dto);

    /**
     * 增加苏银豆和下单 <br>
     * Note: 接口请求异常(加解密异常, 网络异常等), 返回{@code null}
     *
     * @param dto 请求入参
     * @return 执行结果VO, 详见{@link AddPointsAndPayOrderVO}
     */
    String addPointsAndPayOrder(AddPointsAndPayOrderDTO dto);
}
