package cn.com.duiba.customer.link.project.api.remoteservice.app92580;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.customer.link.project.api.remoteservice.app92580.dto.*;
import cn.com.duiba.customer.link.project.api.remoteservice.app92580.vo.*;

import java.util.List;

/**
 * @author LiJiang
 * @description 中弘人寿-接口类
 * @date 2022/12/6
 */
public interface ZhongHongLifeInsurance {
    /**
     * 批量查询用户手机号
     *
     * @param dto dto
     * @return ThirdResVO<List < UserPhoneInfo>>
     */
    ThirdResVO<List<UserPhoneInfo>> queryInfoByUnionId(QueryUserPhoneDTO dto) throws BizException;

    /**
     * 上报中奖信息
     *
     * @param dto dto
     * @return 返回值
     */
    BaseDuiBaResVO<Boolean> reportWinPrizeInfo(ReportWinPrizeInfoDTO dto);

    /**
     * 小程序渠道发送模板消息接口
     *
     * @param dto dto
     * @return 返回值
     */
    BaseDuiBaResVO<Boolean> sendTemplateMessage(SendTemplateMessageDTO dto) throws BizException;

    /**
     * 三方登录, 获取token
     *
     * @param dto dto
     * @return 返回值
     */
    ThirdLoginVO thirdLogin(ThirdLoginDTO dto);

    /**
     * 留资接口
     *
     * @param dto dto
     * @return 返回值
     */
    BaseDuiBaResVO<Boolean> batchSaveLeadsInfo(BatchSaveLeadsInfoDTO dto);

    /**
     * 发送短信验证码接口
     *
     * @param dto dto
     * @return 返回值
     */
    BaseDuiBaResVO<Boolean> sendSmsCode(SendSmsCodeDTO dto);

    /**
     * 查询用户信息
     *
     * @param dto dto
     * @return 返回值
     */
    ThirdResVO<BatchQueryUserInfoVO> batchQueryUserInfo(BatchQueryUserInfoDTO dto) throws BizException;

    /**
     * 查询任务状态
     *
     * @param dto dto
     * @return 返回值
     */
    ThirdResVO<QueryTaskResVO> queryTaskStatus(QueryTaskDTO dto) throws BizException;
}
