package cn.com.duiba.customer.link.project.api.remoteservice.app82621;

import cn.com.duiba.customer.link.project.api.remoteservice.app82621.dto.CallBackProjectxDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app82621.dto.CustInfoProjectxDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app82621.dto.QueryOpenCardInfoDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app82621.dto.TaskInfoProjectxDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app82621.vo.CustomerInfo;
import cn.com.duiba.customer.link.project.api.remoteservice.app82621.vo.OpenCardInfoVO;
import com.alibaba.fastjson.JSONObject;

import java.util.List;

/**
 * 厦门国际银行
 *
 * @Author gjzhao
 * @Date Created in 2022-10-27 2:59 PM
 */
public interface RemoteXiaMenInternationalBank {

    /**
     * 根据uid客户信息查询
     *
     * @param custInfoProjectxDTO 请求参数
     * @return 响应结果
     */
    CustomerInfo queryCustomerInfo(CustInfoProjectxDTO custInfoProjectxDTO);

    /**
     * 查询任务-新版版调用方式
     * 正常情况返回数据如下格式:
     * [
     * {
     * "task": "openFirstAccountTask",
     * "infoList": [
     * {
     * "completeStatus": "Y"
     * },
     * {
     * "completeStatus": "Y"
     * }
     * ]
     * },
     * {
     * "task": "newConsumeTask",
     * "infoList": [
     * {
     * "completeStatus": "N"
     * },
     * {
     * "completeStatus": "Y"
     * }
     * ]
     * }
     * ]
     * <p>
     * 异常情况下返回空数组: []
     *
     * @param taskInfoProjectxDTO 任务信息projectx dto
     * @return {@link List}<{@link JSONObject}>
     */
    List<JSONObject> queryTaskNew(TaskInfoProjectxDTO taskInfoProjectxDTO);

    /**
     * 查询任务-旧版调用方式
     * 正常情况返回数据如下格式:
     * "resultList": [
     * {
     * "openAccountTask": "N"
     * }
     * ]
     *
     * @param taskInfoProjectxDTO
     * @return
     */
    List<JSONObject> queryTaskOld(TaskInfoProjectxDTO taskInfoProjectxDTO);

    /**
     * 推送权益信息
     *
     * @param callBackProjectxDTO 回调信息
     * @return true: 成功; false: 失败
     */
    Boolean pushEquityInfo(CallBackProjectxDTO callBackProjectxDTO);

    /**
     * 查询用户是否持有I类户
     *
     * @param dto dto
     * @return 开卡信息
     */
    OpenCardInfoVO queryOpenCardInfo(QueryOpenCardInfoDTO dto);
}
