/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.customer.link.project.api.remoteservice.app79331;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class RemoteUtils {
    public static final String CHARSET = "UTF-8";
    public static final String RSA_ALGORITHM = "RSA";
    public static final String RSA_PEDDING = "SHA256withRSA";

    public static Map<String, String> convertBeanToMap(Object bean) throws Exception {
        PropertyDescriptor[] propertyDescriptors;
        Class<?> clazz = bean.getClass();
        HashMap<String, String> map = new HashMap<String, String>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
            String name = propertyDescriptor.getName();
            if ("class".equals(name)) continue;
            String value = propertyDescriptor.getReadMethod().invoke(bean, new Object[0]).toString();
            map.put(name, value);
        }
        return map;
    }

    public static <T> Map<String, String> entityToMap(T entity) throws IllegalAccessException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Class<?> clazz = entity.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                field.setAccessible(true);
                if (field.get(entity) == null) continue;
                map.put(field.getName(), field.get(entity).toString());
            }
        }
        return map;
    }

    public static String getSignOriginData(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        map.keySet().stream().sorted().forEach(key -> {
            String value = (String)map.get(key);
            if (StringUtils.isEmpty((CharSequence)value)) {
                return;
            }
            sb.append("&").append((String)key).append("=").append(value);
        });
        return sb.substring(1);
    }

    public static RSAPrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
        return (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
    }

    public static String privateSign(String data, PrivateKey privateKey) {
        try {
            Signature signature = Signature.getInstance(RSA_PEDDING);
            signature.initSign(privateKey);
            signature.update(data.getBytes());
            return Base64.encodeBase64String((byte[])signature.sign());
        }
        catch (Exception e) {
            throw new RuntimeException("\u7b7e\u540d\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }
}

