package cn.com.duiba.customer.link.project.api.remoteservice.app95721;

import cn.com.duiba.customer.link.project.api.remoteservice.app95721.dto.req.PointsHistoryListReqDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app95721.dto.res.*;

import java.util.List;

public interface RemoteMengNiuService {
    /**
     * 会员注册
     * @param mobile 手机号
     * @return 会员ID
     */
    Integer memberRegister(String mobile);
    /**
     * 会员信息查询
     *
     * @param mobile 手机号
     * @return
     */
    MemberInfoQueryRes queryMemberInfo(String mobile);
    /**
     * 查询用户积分余额
     * @param  mobile 手机号
     * @param  type  1 积分,2 成长值
     * @return
     */
    PointsQueryRes queryPoints(String mobile,Integer type);
    /**
     * 用户积分历史记录查询
     * @param  request
     * @return
     */
    PointsHistoryListRes queryPointsHistoryList(PointsHistoryListReqDTO request);
    /**
     * 会员等级与权益查询
     * @param  mobile 手机号
     * @return
     */
    MemberLevelQueryRes queryMemberLevel(String mobile);
    /**
     * 等级信息查询
     * @param  mobile 手机号
     * @return
     */
    List<MemberLevelListRes> queryMemberLevelList(String mobile);
    /**
     * 等级权益查询
     * @param  mobile 手机号
     * @param  memberLevelDetailItemplateId 对应等级
     * @return
     */
    MemberLevelBenefitListRes queryMemberLevelBenefit(String mobile,Integer memberLevelDetailItemplateId);

}
