package cn.com.duiba.customer.link.project.api.remoteservice.app95721;

import cn.com.duiba.customer.link.project.api.remoteservice.app95721.dto.req.*;
import cn.com.duiba.customer.link.project.api.remoteservice.app95721.dto.res.*;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

public interface RemoteMengNiuService {
    /**
     * 领取优惠券验证用户信息
     *
     * @param request 请求
     * @return 返回
     */
    public CouponOpenAndSendRes couponOpenAndSend(CouponOpenAndSendReqDTO request);
    /**
     * 会员注册
     *
     * @param mobile 手机号
     * @return 会员ID
     */
    Long memberRegister(String mobile);


    /**
     * 优惠券-会员注册
     *
     * @param registerDTO 注册信息
     * @return 会员ID
     */
    Long couponMemberRegister(MemberRegisterDTO registerDTO);

    /**
     * 会员信息查询
     *
     * @param mobile 手机号
     * @return
     */
    MemberInfoQueryRes queryMemberInfo(String mobile);

    /**
     * 查询用户积分余额
     *
     * @param mobile 手机号
     * @param type   1 积分,2 成长值
     * @return
     */
    PointsQueryRes queryPoints(String mobile, Integer type);

    /**
     * 用户积分历史记录查询
     *
     * @param request
     * @return
     */
    PointsHistoryListRes queryPointsHistoryList(PointsHistoryListReqDTO request);

    /**
     * 会员等级与权益查询
     *
     * @param mobile 手机号
     * @return
     */
    MemberLevelQueryRes queryMemberLevel(String mobile);

    /**
     * 等级信息查询
     *
     * @param mobile 手机号
     * @return
     */
    List<MemberLevelListRes> queryMemberLevelList(String mobile);

    /**
     * 等级权益查询
     *
     * @param mobile                       手机号
     * @param memberLevelDetailItemplateId 对应等级
     * @return
     */
    MemberLevelBenefitListRes queryMemberLevelBenefit(String mobile,Integer memberLevelDetailItemplateId);

    /**
     * 增加积分
     * @param request dto
     * @return 成功true 失败false
     */
    Boolean increasePoints(IncreasePointsReqDTO request);

    /**
     * 存量会员接入
     * @param request dto
     * @return 存入条数，-1为失败
     */
    Integer batchMemberInsert(BatchMemberInsertReqDTO request);


    boolean modifyMember(MemberModifyReqDTO request);

    /**
     * 批量获取订单填写地址状态
     * @param projectxRecordIds 星速台发奖记录ID
     * @return 订单填写地址集合
     */
    List<FillAddressDto> getFillAddressStatus(String projectxRecordIds);



}
