package cn.com.duiba.customer.link.project.api.remoteservice.app96150;

import cn.com.duiba.customer.link.project.api.remoteservice.app96150.dto.AddCreditRequestDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app96150.dto.QueryCreditRequestDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app96150.dto.SubCreditRequestDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app96150.result.QueryCreditResult;
import cn.com.duiba.customer.link.project.api.remoteservice.app96150.result.YiliCommonResponse;
import cn.com.duiba.customer.link.project.common.annotation.SendPrize;

/**
 * 甄稀-接口对接
 *
 * @author songp
 * @date 2023/12/10 7:08 下午
 */
public interface RemoteZhenXiService {

    /**
     * 加积分接口
     *
     * @param addCreditRequestDto 加积分请求入参
     * @return 为true发放成功
     */
    @SendPrize("key")
    boolean addCredits(AddCreditRequestDto addCreditRequestDto);

    /**
     * 口积分接口
     *
     * @param subCreditRequestDto 扣积分请求入参
     * @return 为true扣减成功
     */
    @SendPrize("key")
    boolean subCredits(SubCreditRequestDto subCreditRequestDto);

    /**
     * 查询积分余额
     *
     * @param queryCreditRequestDto dto
     * @return 查询积分
     */
    QueryCreditResult queryCredit(QueryCreditRequestDto queryCreditRequestDto);


    /**
     * 根据code获取小程序用户数据
     * https://msmarket.msx.digitalyili.com/#/document/index?path=1-1600317933023887361-1600318562210795521
     */
    YiliCommonResponse getUserInfo(String code) throws Exception;
}
