package cn.com.duiba.customer.link.project.api.remoteservice.appisv1.constants;

import cn.com.duiba.customer.link.project.api.remoteservice.appisv1.enums.KeyPrefixEnum;
import org.apache.commons.lang3.StringUtils;

/**
 * @author lvgm
 * @date 2023/7/12
 */
public abstract class KeyFactory {

    /**
     * 获取标记key
     * @param type
     * @param userId
     * @return
     */
    protected static String getTagKey(String type, String userId) {
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isNotBlank(userId)) {
            return sb.append(KeyPrefixEnum.TAG_KEY.getKey()).append(type).append("_").append(userId).toString();
        }
        return sb.append(KeyPrefixEnum.TAG_KEY.getKey()).append(type).toString();

    }

    /**
     * 获取次数key
     */
    protected static String getTimesKey(String type, String userId) {
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isNotBlank(userId)) {
            return sb.append(KeyPrefixEnum.TIMES_KEY.getKey()).append(type).append("_").append(userId).toString();
        }
        return sb.append(KeyPrefixEnum.TIMES_KEY.getKey()).append(type).toString();
    }

}
