package cn.com.duiba.customer.link.project.api.remoteservice.app0202;

import cn.com.duiba.customer.link.project.api.remoteservice.app0202.dto.CouponPushRequest;
import cn.com.duiba.customer.link.project.api.remoteservice.app0202.dto.CouponsRequest;
import cn.com.duiba.customer.link.project.api.remoteservice.app0202.dto.CouponsResponse;
import cn.com.duiba.customer.link.project.api.remoteservice.app0202.dto.OpenStatusRequest;
import cn.com.duiba.customer.link.project.api.remoteservice.app0202.dto.OpenStatusResponse;
import cn.com.duiba.customer.link.project.api.remoteservice.app0202.utils.ResultDto;

/**
 * 星聚会-接口
 *
 * @author songp
 * @date 2024/2/2 4:38 下午
 */
public interface RemoteXingJuHuiService {

    /**
     * 获取优惠券列表
     *
     * @param request 请求参数
     * @return 响应结果
     */
    ResultDto<CouponsResponse> getCouponsList(CouponsRequest request);

    /**
     * 获取当前包厢场次信息
     *
     * @param request 请求参数
     * @return 响应结果
     */
    ResultDto<OpenStatusResponse> queryOpenStatus(OpenStatusRequest request);

    /**
     * 发放优惠券
     *
     * @param request 请求参数
     * @return 响应结果
     */
    ResultDto<String> sendCoupon(CouponPushRequest request);
}
