package cn.com.duiba.customer.link.project.api.remoteservice.app93842;

import cn.com.duiba.customer.link.project.api.remoteservice.app93842.dto.AuthenticationReqDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app93842.dto.GenerateQrCodeReqDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app93842.dto.NpsRequestDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app93842.dto.ThirdDataDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app93842.vo.*;

import java.util.List;
import java.util.Map;

/**
 * 太平洋保险第三方服务
 */
public interface RemoteTaiBaoService {
    /**
     * 外部数据接入接口
     * @param thirdDataDto
     * @return
     */
    ThirdDataVO thirdData(ThirdDataDto thirdDataDto);

    /**
     * 赠送险查询接口
     * @param uid 开发者ID
     * @return true 已领取赠险 false 未领取赠险
     */
    boolean giftInsuranceQuery(String uid);

    /**
     * 查询业务员编号
     * @param uid 开发者ID
     * @return
     */
    AgentVO queryAgent(String uid);

    /**
     * NPS接口
     * @param npsRequestDto 请求参数
     * @return {@link NpsReturnVO}
     */
    NpsReturnVO nps(NpsRequestDto npsRequestDto);

    /**
     * 鉴权获取业务员信息
     *
     * @param dto 请求参数
     * @return 业务员信息
     */
    AuthenticationReturnVO getAuthentication(AuthenticationReqDto dto);

    /**
     * 生成跳转太好店a端太阳码
     *
     * @param dto 请求参数
     * @return 太好店a端太阳码base64
     */
    GenerateQrCodeReturnVO generateQrCode(GenerateQrCodeReqDto dto);

    /**
      * 根据OPENID查询用户年度报告
     * @param openId - 用户OPENID
     * @return {@link ReportEntityVO}
    */
    ReportEntityVO getReport(String openId);

    /**
     * 根据EMPNO查询业务员年度报告
     * @param empNo - 代理人工号
     * @return {@link ReportRespVO}
     */
    EmpReportEntityVO getEmpReport(String empNo);

    /**
     * 获取视频直播数据信息
     *
     * @param todayTime 当天日期
     * @param unionId unionId
     * @return  ProcessDataVO
     */
    Map<String, ProcessDataVO> getProcess(String todayTime, String unionId);

}
