package cn.com.duiba.customer.link.project.api.remoteservice.app89420;

import cn.com.duiba.customer.link.project.api.remoteservice.app89420.dto.RiskResultReq;
import cn.com.duiba.customer.link.project.api.remoteservice.app89420.vo.RiskResultRes;
import cn.com.duiba.customer.link.project.api.remoteservice.app89420.vo.*;

/**
 * @Author WeiChaoChao
 * @Description 口味王接口
 * @Date 2023/1/6
 **/
public interface RemoteKwwService {
    /**
     * 2.3.18
     * 查询是否完善用户信息
     *
     * @param userId 用户Id
     * @return
     */
    HasPerfectUserInfoRes hasPerfectUserInfo(String userId);

    /**
     * 2.3.19
     * 查询用户消费记录
     *
     * @param req
     * @return
     */
    ConsumeRecordRes queryConsumeRecord(ConsumeRecordReq req);

    /**
     * 2.3.21
     * 查询用户消费记录
     *
     * @param req
     * @return
     */
    NewConsumeRecordRes queryNewConsumeRecord(ConsumeRecordReq req);

    /**
     * 2.3.20
     * 查询用户新年订阅消息记录
     *
     * @param userId
     * @param activityNo 不传时返回两个活动的订阅状态
     * @return
     */
    SubscribeNewYearMsgRecordRes querySubscribeMsgRecord(String userId, String activityNo);

    /**
     * 查询小程序订阅状态
     * @param userId 用户ID
     * @param openId dcustomMap中取到到"openid"
     * @param id 订阅ID
     * @return 订阅结果
     */
    ChannelSubscribeRes queryChannelSubscribeRes(String userId, String openId, String id);


    /**
     * 用户手动补发接口
     *
     * @param req
     */
    SelfPushResultRes selfPush(SelfPushReq req);


    /**
     * 批量推送发钱接口
     * 具体怎么推送，一次推多少条和技术支持确认
     *
     * @param req
     */
    void sendMoney(SendMoneyReq req);

    /**
     * 活动信息同步
     * @param req
     * @return boolean
     */
    boolean activityInfoSynchronization(ActivityInfoSynchronizationReq req);

    /**
     * 查询活动信息
     * @param req
     * @return QueryActivityInfoRes
     */
    QueryActivityInfoRes queryActivityInfo(QueryActivityInfoReq req);


    /**
     * 2.3.30
     * 年度账单
     * @param userId
     * @return {@link Bill2023Resp}
     */
    Bill2023Resp get2023BillInfo(String userId);

    /**
     * 发放红包
     * @param req
     * @return boolean
     */
    boolean sendSpecialRed(SpecialRedReq req);


    /**
     * 发放优惠券
     * @param req
     * @return boolean
     */
    boolean sendSpecialCoupon(SpecialCouponReq req);

    /**
     * 查询风控结果
     *
     * @param req 请求入参
     * @return 风控结果
     */
    RiskResultRes queryRiskResultRes(RiskResultReq req);

}
