package cn.com.duiba.customer.link.project.api.remoteservice.appisv1.dao;

import cn.com.duiba.customer.link.project.api.remoteservice.appisv1.constants.KeyFactory;
import cn.com.duiba.projectx.sdk.CommonApi;
import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.utils.ExpireTime;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author KvDao
 * @Description
 * @date 2023/7/12 11:54
 */
public class IsvKvDao extends KeyFactory {

    /**
     * 设置标记
     * @param api
     * @param type
     * @param userId
     * @return
     */
    public static boolean setTag(UserRequestApi api, String type, String userId, ExpireTime expireTime) {
        return api.getKeyValueApi().setIfAbsent(getTagKey(type, userId), 1L, expireTime);
    }

    /**
     * 删除标记
     * @param api
     * @param type
     * @param userId
     * @return
     */
    public static boolean delTag(UserRequestApi api, String type, String userId) {
        return api.getKeyValueApi().delete(getTagKey(type, userId));
    }

    /**
     * 获取标记
     * @param api
     * @param type
     * @param userId
     * @return
     */
    public static Long getTag(UserRequestApi api, String type, String userId) {
        return api.getKeyValueApi().getLong(getTagKey(type, userId));
    }

    /**
     * 递增次数
     * @param api
     * @param type
     * @param userId
     * @return
     */
    public static boolean incrTimes(UserRequestApi api, String type, String userId,long offset,Long limit, ExpireTime expireTime) {
        return api.getKeyValueApi().increase(getTimesKey(type, userId),offset,limit,expireTime);
    }

    /**
     * 获取次数
     * @param api
     * @param type
     * @param userId
     * @return
     */
    public static Long getTimes(UserRequestApi api, String type, String userId) {
        return api.getKeyValueApi().getLong(getTimesKey(type, userId));
    }

    /**
     * 删除次数
     * @param api
     * @param type
     * @param userId
     * @return
     */
    public static boolean delTimes(UserRequestApi api, String type, String userId) {
        return api.getKeyValueApi().delete(getTimesKey(type, userId));
    }

    /**
     * 批量查询Long类型value值
     *
     * @param api      api
     * @param makeKeyFunction 拼接key的方法
     * @param keys     key值集合
     * @param <T>      key值类型
     * @return key:key键 value:键值
     */
    public static <T> Map<T, Long> batchGetLongValueMap(CommonApi api,
                                                        Function<T, String> makeKeyFunction,
                                                        List<T> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptyMap();
        }

        keys = keys.stream().distinct().collect(Collectors.toList());
        List<String> multiKeys = keys.stream().map(makeKeyFunction).collect(Collectors.toList());
        List<Long> multiValues = api.getKeyValueApi().multiGetLong(multiKeys);
        Map<T, Long> retMap = new HashMap<>();
        for (int i = 0; i < multiKeys.size(); i++) {
            retMap.put(keys.get(i), Optional.ofNullable(multiValues.get(i)).orElse(0L));
        }
        return retMap;
    }

    /**
     * 批量查询Long类型值是否大于0
     *
     * @param api      api
     * @param makeKeyFunction 拼接key的方法
     * @param keys     key值集合
     * @param <T>      key值类型
     * @return key:key键 value:为true大于0
     */
    public static <T> Map<T, Boolean> batchGetLongExistMap(CommonApi api,
                                                           Function<T, String> makeKeyFunction,
                                                           List<T> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptyMap();
        }

        keys = keys.stream().distinct().collect(Collectors.toList());
        List<String> multiKeys = keys.stream().map(makeKeyFunction).collect(Collectors.toList());
        List<Long> multiValues = api.getKeyValueApi().multiGetLong(multiKeys);
        Map<T, Boolean> retMap = new HashMap<>();
        for (int i = 0; i < multiKeys.size(); i++) {
            retMap.put(keys.get(i), Optional.ofNullable(multiValues.get(i)).orElse(0L) > 0L);
        }
        return retMap;
    }

    /**
     * 批量查询String类型值
     *
     * @param api      api
     * @param makeKeyFunction 拼接key的方法
     * @param keys     key值集合
     * @param <T>      key值类型
     * @return key:key键 value:string值
     */
    public static <T> Map<T, String> batchGetStringValueMap(CommonApi api,
                                                            Function<T, String> makeKeyFunction,
                                                            List<T> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptyMap();
        }

        keys = keys.stream().distinct().collect(Collectors.toList());
        List<String> multiKeys = keys.stream().map(makeKeyFunction).collect(Collectors.toList());
        List<String> multiValues = api.getKeyValueApi().multiGet(multiKeys);
        Map<T, String> retMap = new HashMap<>();
        for (int i = 0; i < multiKeys.size(); i++) {
            retMap.put(keys.get(i), multiValues.get(i));
        }
        return retMap;
    }

    /**
     * 批量查询String类型值存在
     *
     * @param api      api
     * @param makeKeyFunction 拼接key的方法
     * @param keys     key值集合
     * @param <T>      key值类型
     * @return key:key键 value:为true-存在
     */
    public static <T> Map<T, Boolean> batchGetStringExistMap(CommonApi api,
                                                             Function<T, String> makeKeyFunction,
                                                             List<T> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptyMap();
        }

        keys = keys.stream().distinct().collect(Collectors.toList());
        List<String> multiKeys = keys.stream().map(makeKeyFunction).collect(Collectors.toList());
        List<String> multiValues = api.getKeyValueApi().multiGet(multiKeys);
        Map<T, Boolean> retMap = new HashMap<>();
        for (int i = 0; i < multiKeys.size(); i++) {
            retMap.put(keys.get(i), StringUtils.isNotBlank(multiValues.get(i)));
        }
        return retMap;
    }

}
