package cn.com.duiba.customer.link.project.api.remoteservice.app79331.vo;

import cn.com.duiba.customer.link.project.api.remoteservice.app79331.dto.CstStatusEnum;

import java.util.Objects;

/**
 * @author zhangdaqing
 * @Description
 * @date 2023/4/15 17:52
 */
public class BindCardCustDataVO {
    /**
     * 客户达标情况查询结果, 数组形式
     */
    private String compGrp;

    /**
     * 客户新/老绑卡标志: 0-新绑卡客户, 1-老绑卡客户, 2-未绑定过客户
     */
    private String cstStatus;

    /**
     * 应用Id
     */
    private String clientId;

    /**
     * 时间戳
     */
    private Long timestamp;

    /**
     * 时间戳
     */
    private String signInfo;


    /**
     * 是否绑卡
     *
     * @param bindCardCustData 绑定信用卡cust数据
     * @return boolean
     */
    public static boolean hasBindCard(BindCardCustDataVO bindCardCustData) {
        if (bindCardCustData == null) {
            return false;
        }
        String cstStatus = bindCardCustData.getCstStatus();
        if (cstStatus == null) {
            return false;
        }
        return cstStatus.equals(CstStatusEnum.NEW_BIND.getCode()) || cstStatus.equals(CstStatusEnum.OLD_BIND.getCode());
    }

    /**
     * 是否是新绑卡用户
     *
     * @param bindCardCustData 绑定信用卡cust数据
     * @return boolean
     */
    public static boolean isNewBindCardUser(BindCardCustDataVO bindCardCustData) {
        if (bindCardCustData == null) {
            return false;
        }
        String cstStatus = bindCardCustData.getCstStatus();
        return Objects.equals(CstStatusEnum.NEW_BIND.getCode(), cstStatus);
    }

    // ---------------------------------------------------------------------------------------------- GETTER AND SETTER

    public String getCompGrp() {
        return compGrp;
    }

    public void setCompGrp(String compGrp) {
        this.compGrp = compGrp;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getSignInfo() {
        return signInfo;
    }

    public void setSignInfo(String signInfo) {
        this.signInfo = signInfo;
    }

    public void setCstStatus(String cstStatus) {
        this.cstStatus = cstStatus;
    }

    public String getCstStatus() {
        return cstStatus;
    }
}
