package cn.com.duiba.customer.link.project.api.remoteservice.app83591.request;

import java.io.Serializable;

/**
 * 基础请求参数
 *
 * @author songp
 * @date 2023/6/20 8:08 PM
 */
public class BaseRequest implements Serializable {

    /**
     * 目标系统标识
     * 填：PMMS
     */
    private String psystemId = "PMMS";

    /**
     * 服务名
     * 填：pmms-api-access
     */
    private String serviceName = "pmms-api-access";

    /**
     * 渠道ID
     * 1：移动终端；
     * 2：PC端；
     * 3：第三方厂商；
     */
    private String channelFlag = "3";

    /**
     * 设备唯一标志号
     * 目前上送随机字符串即可
     */
    private String deviceNo;

    /**
     * 调用方系统标识
     * eg: PMMS
     */
    private String csystemId = "PMMS";

    /**
     * 调用时间(待确认)
     * eg: 20210218
     * "yyyy/MM/dd HH:mm:ss"
     */
    private String transTime;

    /**
     * 流水号
     * 用于标识一笔交易的请求和返回
     */
    private String serialId;

    /**
     * 根流水号
     * 唯一标识一笔交易（由第一个服务端生成）
     */
    private String traceId;

    /**
     * 子流水号
     * 唯一标识一次服务调用
     */
    private String spanId;

    /**
     * 各接口名
     */
    private String method;

    /**
     * 扩展参数
     */
    private Ext ext;

    /**
     * 语言
     */
    private String languageCode = "zh_CN";

    /**
     * 终端应用版本
     */
    private String versionNo = "6.10.1";

    /**
     * 前端上送唯一标识
     */
    private String sessionId = "df54wefwew6e5";



    public Ext getExt() {
        return ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public String getLanguageCode() {
        return languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getVersionNo() {
        return versionNo;
    }

    public void setVersionNo(String versionNo) {
        this.versionNo = versionNo;
    }

    public String getSessionId() {
        return sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getPsystemId() {
        return psystemId;
    }

    public void setPsystemId(String psystemId) {
        this.psystemId = psystemId;
    }

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getChannelFlag() {
        return channelFlag;
    }

    public void setChannelFlag(String channelFlag) {
        this.channelFlag = channelFlag;
    }

    public String getDeviceNo() {
        return deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public String getCsystemId() {
        return csystemId;
    }

    public void setCsystemId(String csystemId) {
        this.csystemId = csystemId;
    }

    public String getTransTime() {
        return transTime;
    }

    public void setTransTime(String transTime) {
        this.transTime = transTime;
    }

    public String getSerialId() {
        return serialId;
    }

    public void setSerialId(String serialId) {
        this.serialId = serialId;
    }

    public String getTraceId() {
        return traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getSpanId() {
        return spanId;
    }

    public void setSpanId(String spanId) {
        this.spanId = spanId;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public static class Ext {

        /**
         * 核心客户号
         */
        private String cif;

        /**
         * 手机号
         */
        private String mobileNumber;

        /**
         * 01：已加密
         * 02：未加密
         *
         */
        private String isEncrypt = "01";

        /**
         * 三方接入标识
         * 兑吧需上送兑吧厂商标识，例如(duiba...)
         */
        private String tripartiteId = "duiba";

        public String getCif() {
            return cif;
        }

        public void setCif(String cif) {
            this.cif = cif;
        }

        public String getMobileNumber() {
            return mobileNumber;
        }

        public void setMobileNumber(String mobileNumber) {
            this.mobileNumber = mobileNumber;
        }

        public String getIsEncrypt() {
            return isEncrypt;
        }

        public void setIsEncrypt(String isEncrypt) {
            this.isEncrypt = isEncrypt;
        }

        public String getTripartiteId() {
            return tripartiteId;
        }

        public void setTripartiteId(String tripartiteId) {
            this.tripartiteId = tripartiteId;
        }
    }

}
