package cn.com.duiba.customer.link.project.api.remoteservice.app83591.response;

import cn.com.duiba.customer.link.project.api.remoteservice.app83591.dto.ThirdPrizeTypeEnum;

/**
 * 查询中奖记录row数据
 *
 * @author songp
 * @date 2023/6/20 2:48 PM
 */
public class QueryUserWinRecordInfoRow {

    /**
     * 权益编号字段(奖品类型为权益奖品时才会返回该字段)
     */
    private String rightNo;

    /**
     * 奖品等级
     */
    private String prizeLevel;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     * 奖品类型
     * (merchantDiscount:商户优惠券类
     * priorityPrize：权益服务
     * VIPIntegral：尊享积分)
     * @see ThirdPrizeTypeEnum
     */
    private String prizeType;

    private String partakeTime;

    /**
     * 奖品到期时间(yyyy/MM/dd HH:mm:ss)
     */
    private String prizeEndTime;

    /**
     * 中奖ID
     */
    private String winId;

    /**
     * 权益奖品跳转链接
     * 奖品类型为权益奖品时跳转链接detailUrl字段
     * （针对请求clrp接口“单客户活动权益账户列表查询（LSAC42）”不返回的奖品，detailUrl字段为空）
     *
     */
    private String detailUrl;

    /**
     * 奖品ID
     */
    private String prizeId;

    /**
     * 奖品价值
     */
    private String prizeValue;

    /**
     * 中奖时间(yyyy/MM/dd HH:mm:ss)
     */
    private String winTime;

    /**
     * 奖品使用状态(0:已使用 1:未使用)
     */
    private String prizeStatus;

    /**
     * 活动id
     */
    private String activityId;

    /**
     * 奖品状态
     * priorityPrize（权益）：
     * 0：建立
     *    1：生效
     *    2：过期
     *    3：自动失效
     *    4:手工失效
     *    5：已核卡
     *    6：已达标
     *    7：已发放
     *    8：发放失败
     *    9：已使用
     *    10：已手工领取
     *
     * VIPIntegral（尊享积分）：
     *    0：失败
     *    1：成功
     *    2：待处理
     *
     * PMMS奖品状态
     *   0：已使用
     *   1：未使用
     *   2：已作废
     *   3：已过期
     *   4：已冻结
     */
    private String prizeStatusDetail;

    public String getRightNo() {
        return rightNo;
    }

    public void setRightNo(String rightNo) {
        this.rightNo = rightNo;
    }

    public String getPrizeLevel() {
        return prizeLevel;
    }

    public void setPrizeLevel(String prizeLevel) {
        this.prizeLevel = prizeLevel;
    }

    public String getPrizeName() {
        return prizeName;
    }

    public void setPrizeName(String prizeName) {
        this.prizeName = prizeName;
    }

    public String getPrizeType() {
        return prizeType;
    }

    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType;
    }

    public String getPartakeTime() {
        return partakeTime;
    }

    public void setPartakeTime(String partakeTime) {
        this.partakeTime = partakeTime;
    }

    public String getPrizeEndTime() {
        return prizeEndTime;
    }

    public void setPrizeEndTime(String prizeEndTime) {
        this.prizeEndTime = prizeEndTime;
    }

    public String getWinId() {
        return winId;
    }

    public void setWinId(String winId) {
        this.winId = winId;
    }

    public String getDetailUrl() {
        return detailUrl;
    }

    public void setDetailUrl(String detailUrl) {
        this.detailUrl = detailUrl;
    }

    public String getPrizeId() {
        return prizeId;
    }

    public void setPrizeId(String prizeId) {
        this.prizeId = prizeId;
    }

    public String getPrizeValue() {
        return prizeValue;
    }

    public void setPrizeValue(String prizeValue) {
        this.prizeValue = prizeValue;
    }

    public String getWinTime() {
        return winTime;
    }

    public void setWinTime(String winTime) {
        this.winTime = winTime;
    }

    public String getPrizeStatus() {
        return prizeStatus;
    }

    public void setPrizeStatus(String prizeStatus) {
        this.prizeStatus = prizeStatus;
    }

    public String getActivityId() {
        return activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getPrizeStatusDetail() {
        return prizeStatusDetail;
    }

    public void setPrizeStatusDetail(String prizeStatusDetail) {
        this.prizeStatusDetail = prizeStatusDetail;
    }
}
