package cn.com.duiba.customer.link.project.api.remoteservice.app86760;

import cn.com.duiba.customer.link.project.api.remoteservice.app86760.dto.*;
import cn.com.duiba.customer.link.project.api.remoteservice.app86760.vo.AddPointsAndPayOrderVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app86760.vo.CustomerTransactionRecordVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app86760.vo.GetProfitInfoVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app86760.vo.GetUserTotalAssetsVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app86760.vo.MessageCodeVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app86760.vo.PhoneNumRegisterCheckVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app86760.vo.RecommendNewVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app86760.vo.QueryGuestVO;

/**
 * 江苏银行接口调用
 *
 * @author xulei
 * @since 1.0.0
 */
public interface RemoteJiangSuBank {

    /**
     * 查询用户持有资产 <br>
     * Note: 接口请求异常(加解密异常, 网络异常等), 返回{@code null}
     *
     * @param dto 请求入参
     * @return 用户持有资产VO, 详见{@link GetUserTotalAssetsVO}
     */
    String getUserTotalAssets(GetUserTotalAssetsDTO dto);

    /**
     * 查询推荐基金产品接口 <br>
     * Note: 接口请求异常(加解密异常, 网络异常等), 返回{@code null}
     *
     * @return 推荐基金产品VO, 详见{@link RecommendNewVO}
     */
    String recommendNew();

    /**
     * 查询用户收益信息 <br>
     * Note: 接口请求异常(加解密异常, 网络异常等), 返回{@code null}
     *
     * @param dto 请求入参
     * @return 用户收益信息VO, 详见{@link GetProfitInfoVO}
     */
    String getProfitInfo(GetProfitInfoDTO dto);

    /**
     * 增加苏银豆和下单 <br>
     * Note: 接口请求异常(加解密异常, 网络异常等), 返回{@code null}
     *
     * @param dto 请求入参
     * @return 执行结果VO, 详见{@link AddPointsAndPayOrderVO}
     */
    String addPointsAndPayOrder(AddPointsAndPayOrderDTO dto);

    /**
     * 获取验证码 <br>
     * Note: 接口请求异常(加解密异常, 网络异常等), 返回{@code null}
     *
     * @param dto 请求入参
     * @return 执行结果VO, 详见{@link MessageCodeVO}
     */
    String messageCode(MessageCodeDTO dto);

    /**
     * 手机号是否注册 <br>
     * Note: 接口请求异常(加解密异常, 网络异常等), 返回{@code null}
     *
     * @param dto 请求入参
     * @return 执行结果VO, 详见{@link PhoneNumRegisterCheckVO}
     */
    String phoneNumRegisterCheck(PhoneNumRegisterCheckDTO dto);

    /**
     * 游客登记 <br>
     * Note: 接口请求异常(加解密异常, 网络异常等), 返回{@code null}
     *
     * @param dto 请求入参
     * @return 执行结果VO, 详见{@link QueryGuestVO}
     */
    String queryGuest(QueryGuestDTO dto);


    /**
     * 入金查询 <br>
     * Note: 接口请求异常(加解密异常, 网络异常等), 返回{@code null}
     *
     * @param dto 请求入参
     * @return 执行结果VO, 详见{@link CustomerTransactionRecordVO}
     */
    String customerTransactionRecord(CustomerTransactionRecordDTO dto);

    /**
     * 查询任务完成列表
     * @param dto 请求入参
     * @return 执行结果VO
     */
    String queryUserTaskList(QueryTaskDTO dto);

    /**
     * 查询购买理财产品的总金额
     * @param dto 请求入参
     * @return 执行结果VO 详见{@link QueryTaskMoneyResultDTO}
     */
    String queryUserProductTotalMoney(QueryTaskMoneyDTO dto);


    /**
     * 查询任务完成列表 ⚠️B产线（非正式）
     * @param dto 请求入参
     * @return 执行结果VO
     */
    String queryUserTaskListForB(QueryTaskDTO dto);

    /**
     * 查询购买理财产品的总金额 ⚠️B产线（非正式）
     * @param dto 请求入参
     * @return 执行结果VO 详见{@link QueryTaskMoneyResultDTO}
     */
    String queryUserProductTotalMoneyForB(QueryTaskMoneyDTO dto);


    /**
     * 增加苏银豆和下单 ⚠️B产线（非正式）
     * Note: 接口请求异常(加解密异常, 网络异常等), 返回{@code null}
     *
     * @param dto 请求入参
     * @return 执行结果VO, 详见{@link AddPointsAndPayOrderVO}
     */
    String addPointsAndPayOrderForB(AddPointsAndPayOrderDTO dto);
}
