package cn.com.duiba.customer.link.project.api.remoteservice.app89569;

import cn.com.duiba.customer.link.project.api.remoteservice.app89569.dto.HereQueryReq;
import cn.com.duiba.customer.link.project.api.remoteservice.app89569.dto.Result;
import cn.com.duiba.customer.link.project.api.remoteservice.app89569.vo.AllGameDetailInfo;
import cn.com.duiba.customer.link.project.api.remoteservice.app89569.vo.AllGameInfo;
import cn.com.duiba.customer.link.project.api.remoteservice.app89569.vo.SingleGameInfo;
import cn.com.duiba.customer.link.project.api.remoteservice.app89569.vo.TeamInfo;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 英雄联盟赛事信息service
 */
public interface RemoteHeroTeamService {
    /**
     * 获取战队信息
     */
    Result<List<TeamInfo>> getTeamInfo(HereQueryReq queryReq);

    /**
     * 获取获取赛事信息
     * @param  queryReq 查询条件
     */
    Result<List<AllGameInfo>> getAllGameInfo(HereQueryReq queryReq);

    /**
     * 获取获取赛程赛果信息
     * @param id 赛事ID
     */
    Result<List<AllGameDetailInfo>> getAllGameScheduleAndResultInfo(String id);

    /**
     * 获取单场比赛信息
     * @param  queryReq 查询条件
     * ⚠️：该接口将会返回英雄联盟所有单局比赛数据，请使用靠近完赛时间的time参数，避免返回数据量过大
     *
     */
    Result<List<SingleGameInfo>> getSingleGameInfo(HereQueryReq queryReq);
}
