package cn.com.duiba.customer.link.project.api.remoteservice.app94996;

import cn.com.duiba.customer.link.project.api.remoteservice.app94996.dto.InstrumentDataDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app94996.dto.MarketDataDto;

import java.util.List;

/**
 * @author zhangdaqing
 * @Description
 * @date 2023/10/6 16:08
 */
public interface RemoteFuturesApiService {
    /**
     * 根据手机号查询用户是否开户接口
     *
     * @param mobileNo
     * @return boolean
     */
    Boolean checkInvestor(String mobileNo);


    /**
     * 查询当日主力合约
     *
     * @param tradingDay
     * @return {@link List}<{@link InstrumentDataDto}>
     */
    List<InstrumentDataDto> getMainInstrument(String tradingDay);

    /**
     * 查询期货合约涨跌信息接口
     *
     * @param tradingDay
     * @param instrumentId
     * @return {@link MarketDataDto}
     */
    MarketDataDto getInstrument(String tradingDay, String instrumentId);


}

