package cn.com.duiba.customer.link.project.api.remoteservice.app96254;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.customer.link.project.api.remoteservice.app96254.dto.ExternalConcatResp;
import cn.com.duiba.customer.link.project.api.remoteservice.app96254.dto.OrderQueryReq;
import cn.com.duiba.customer.link.project.api.remoteservice.app96254.dto.OrderQueryResp;
import cn.com.duiba.customer.link.project.api.remoteservice.app96254.dto.QueryMemberReq;
import cn.com.duiba.customer.link.project.api.remoteservice.app96254.dto.QueryMemberResp;
import cn.com.duiba.customer.link.project.api.remoteservice.app96254.dto.ResultDto;

/**
 * 恰恰接口
 *
 * @author songp
 * @date 2024/1/4 3:59 下午
 */
public interface RemoteQiaQiaService {


    /**
     * 获取企微用户信息
     * 判定已添加企微条件：
     * Objects.nonNull(ExternalConcatResp)
     * && ExternalConcatResp.getType()=2
     * && StringUtils.isNotBlank(ExternalConcatResp.externalUserid)
     *
     * @param unionId unionId
     * @return 返回值
     */
    ResultDto<ExternalConcatResp> getExternalConcat(String unionId) throws BizException;

    /**
     * 查询微信会员信息
     *
     * @param req 请求入参
     * @return 返回
     * @throws BizException e
     */
    QueryMemberResp queryMemberInfo(QueryMemberReq req) throws BizException;

    /**
     * 分页查询消费订单
     *
     * @param req req
     * @return 返回
     * @throws BizException e
     */
    OrderQueryResp pageOrderQuery(OrderQueryReq req) throws BizException;
}
