package cn.com.duiba.customer.link.project.api.remoteservice.app96254.dto;

/**
 * 查询会正向订单以及子订单
 *
 * @author songp
 * @date 2024/1/10 5:03 下午
 */
public class OrderQueryReq {

    //  200: 请求成功
    // 401: api-gateway鉴权失败
    // 403: 禁止访问
    // 404: 请求的URL不存在
    // 408: 请求超时
    // 500: 服务内部异常
    // 502: 网关异常
    // 503: 服务不可用

    /**
     * 会员ID(必填)
     */
    private String memberId;

    /**
     * 渠道类型: YOUZAN,默认所有渠道
     */
    private String channelType;

    /**
     * 会员类型,固定值: qiaqia
     */
    private String memberType = "qiaqia";

    /**
     * 默认1，页码
     */
    private Integer currentPage;

    /**
     * 默认10，每页条数
     */
    private Integer pageSize;

    /**
     * 订单状态:
     * CREATED-下单,
     * CANCELLED-订单取消,
     * DELIVERED-已发货,
     * CONFIRMED-卖家已确认,
     * FINISHED-完成,
     * REFUND_START-退款开始,
     * REFUND_FINISHED-退款完成
     *
     */
    private String status;

    public String getMemberId() {
        return memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public String getChannelType() {
        return channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public String getMemberType() {
        return memberType;
    }

    public void setMemberType(String memberType) {
        this.memberType = memberType;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}
