package cn.com.duiba.customer.link.project.api.remoteservice.app97276;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.customer.link.project.api.remoteservice.app97276.vo.NewUserInfoVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app97276.vo.QueryRecordRequest;
import cn.com.duiba.customer.link.project.api.remoteservice.app97276.vo.QueryRecordResponse;
import cn.com.duiba.customer.link.project.api.remoteservice.app97276.vo.Result;
import cn.com.duiba.customer.link.project.api.remoteservice.app97276.vo.TokenRequest;
import cn.com.duiba.customer.link.project.api.remoteservice.app97276.vo.TokenResponse;
import cn.com.duiba.customer.link.project.api.remoteservice.app97276.vo.YiliCommonResponse;

/**
 * 金典-remote
 *
 * @author songp
 * @date 2024/6/27 3:00 下午
 */
public interface RemoteJinDianService {


    /**
     * 根据code获取小程序用户数据
     * https://msmarket.msx.digitalyili.com/#/document/index?path=1-1600317933023887361-1600318562210795521
     */
    YiliCommonResponse<NewUserInfoVO> getUserInfo(String code) throws Exception;

    /**
     * 获取查询核销记录BearerToken
     *
     * @param request request
     * @return token
     */
    Result<TokenResponse> getToken() throws BizException;

    /**
     * 查询核销记录列表
     *
     * @param request request
     * @return 核销记录列表
     */
    Result<QueryRecordResponse> queryRecordList(QueryRecordRequest request) throws BizException;
}
