package cn.com.duiba.customer.link.project.api.remoteservice.appisv1.task;

import cn.com.duiba.projectx.sdk.component.task.dto.TaskItemResult;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * 类型转换器
 *
 * @author songp
 * @date 2024/3/13 3:26 下午
 */
public class ItemResultConverter implements Converter<TaskItemResult, ActivityTaskItemResult> {

        private final int taskStatus;

        public ItemResultConverter(int taskStatus) {
            this.taskStatus = taskStatus;
        }

        /**
         * 包装{@link TaskItemResult}为{@link ActivityTaskItemResult}追加状态字段<br>
         * 状态规则如下
         * <li>去完成：无领取码，已完成次数小于总次数</li>
         * <li>去领取：有领取码</li>
         * <li>已完成：无领取码，已完成次数等于总次数</li>
         */
        @Override
        public ActivityTaskItemResult convert(TaskItemResult source) {
            ActivityTaskItemResult itemResult = BeanUtils.copy(source, ActivityTaskItemResult.class);
            itemResult.setTaskStatus(taskStatus);
            return itemResult;
        }
    }