package cn.com.duiba.customer.link.project.api.remoteservice.app95721.dto.res;

import java.util.List;

//会员等级与权益查询返回
public class MemberLevelQueryRes {
    //会员id
    private Integer memberId;
    private CurrentLevel currentLevel;
    private String changeType;
    private String changeTime;
    private ChangeFrom changeFrom;
    private NextLevel nextLevel;
    //上一等级阀值
    private Number prevLevelThreshold;

    /**
     * 当前升级进度（已达成的消费金额）
     * 若当前进度大于下一级进度，说明金额条件已达到，但升级出现延迟，
     * 前端可以取整不超过 100%
     */
    private Number currentLevelProgress;

    /**
     * 下一等级阀值（升级到下一级需要达成的消费金额）
     * 为空表示已达到顶级或配置异常，前端应该可以不提示升级的文案
     */
    private Number nextLevelProgress;
    private List<CurrentBenefitList> currentBenefitList;
    public static class CurrentLevel {
        /**
         * 等级模板 ID
         */
        public Integer memberLevelTemplateId;

        /**
         * 等级 ID
         */
        public Integer memberLevelDetailTemplateId;

        /**
         * 等级名称
         */
        public String memberLevelDetailTemplateName;

        /**
         * 等级图标路径
         */
        public String imagePath;

        public Integer getMemberLevelTemplateId() {
            return memberLevelTemplateId;
        }

        public void setMemberLevelTemplateId(Integer memberLevelTemplateId) {
            this.memberLevelTemplateId = memberLevelTemplateId;
        }

        public Integer getMemberLevelDetailTemplateId() {
            return memberLevelDetailTemplateId;
        }

        public void setMemberLevelDetailTemplateId(Integer memberLevelDetailTemplateId) {
            this.memberLevelDetailTemplateId = memberLevelDetailTemplateId;
        }

        public String getMemberLevelDetailTemplateName() {
            return memberLevelDetailTemplateName;
        }

        public void setMemberLevelDetailTemplateName(String memberLevelDetailTemplateName) {
            this.memberLevelDetailTemplateName = memberLevelDetailTemplateName;
        }

        public String getImagePath() {
            return imagePath;
        }

        public void setImagePath(String imagePath) {
            this.imagePath = imagePath;
        }
    }

    public static class ChangeFrom {
        /**
         * 等级模板 ID
         */
        public Integer memberLevelTemplateId;

        /**
         * 等级 ID
         */
        public Integer memberLevelDetailTemplateId;

        /**
         * 等级名称
         */
        public String memberLevelDetailTemplateName;
        /*
        * 等级图标
        */
        public String imagePath;

        public Integer getMemberLevelTemplateId() {
            return memberLevelTemplateId;
        }

        public void setMemberLevelTemplateId(Integer memberLevelTemplateId) {
            this.memberLevelTemplateId = memberLevelTemplateId;
        }

        public Integer getMemberLevelDetailTemplateId() {
            return memberLevelDetailTemplateId;
        }

        public void setMemberLevelDetailTemplateId(Integer memberLevelDetailTemplateId) {
            this.memberLevelDetailTemplateId = memberLevelDetailTemplateId;
        }

        public String getMemberLevelDetailTemplateName() {
            return memberLevelDetailTemplateName;
        }

        public void setMemberLevelDetailTemplateName(String memberLevelDetailTemplateName) {
            this.memberLevelDetailTemplateName = memberLevelDetailTemplateName;
        }

        public String getImagePath() {
            return imagePath;
        }

        public void setImagePath(String imagePath) {
            this.imagePath = imagePath;
        }
    }

    public static class NextLevel {
        /**
         * 等级模板 ID
         */
        public Integer memberLevelTemplateId;

        /**
         * 等级 ID
         */
        public Integer memberLevelDetailTemplateId;

        /**
         * 等级名称
         */
        public String memberLevelDetailTemplateName;

        /**
         * 等级图标路径
         */
        public String imagePath;

        public Integer getMemberLevelTemplateId() {
            return memberLevelTemplateId;
        }

        public void setMemberLevelTemplateId(Integer memberLevelTemplateId) {
            this.memberLevelTemplateId = memberLevelTemplateId;
        }

        public Integer getMemberLevelDetailTemplateId() {
            return memberLevelDetailTemplateId;
        }

        public void setMemberLevelDetailTemplateId(Integer memberLevelDetailTemplateId) {
            this.memberLevelDetailTemplateId = memberLevelDetailTemplateId;
        }

        public String getMemberLevelDetailTemplateName() {
            return memberLevelDetailTemplateName;
        }

        public void setMemberLevelDetailTemplateName(String memberLevelDetailTemplateName) {
            this.memberLevelDetailTemplateName = memberLevelDetailTemplateName;
        }

        public String getImagePath() {
            return imagePath;
        }

        public void setImagePath(String imagePath) {
            this.imagePath = imagePath;
        }
    }

    public static class CurrentBenefitList {
        //权益名称
        public String name;

        //权益图标路径
        public String imagePath;

        //权益备注
        public String note;

        //当前会员是否拥有该权益
        public Boolean included;

        //跳转按钮文案
        public String forwardBtnText;

        //跳转链接
        public String forwardLink;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getImagePath() {
            return imagePath;
        }

        public void setImagePath(String imagePath) {
            this.imagePath = imagePath;
        }

        public String getNote() {
            return note;
        }

        public void setNote(String note) {
            this.note = note;
        }

        public Boolean getIncluded() {
            return included;
        }

        public void setIncluded(Boolean included) {
            this.included = included;
        }

        public String getForwardBtnText() {
            return forwardBtnText;
        }

        public void setForwardBtnText(String forwardBtnText) {
            this.forwardBtnText = forwardBtnText;
        }

        public String getForwardLink() {
            return forwardLink;
        }

        public void setForwardLink(String forwardLink) {
            this.forwardLink = forwardLink;
        }
    }

    public Integer getMemberId() {
        return memberId;
    }

    public void setMemberId(Integer memberId) {
        this.memberId = memberId;
    }

    public CurrentLevel getCurrentLevel() {
        return currentLevel;
    }

    public void setCurrentLevel(CurrentLevel currentLevel) {
        this.currentLevel = currentLevel;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public String getChangeTime() {
        return changeTime;
    }

    public void setChangeTime(String changeTime) {
        this.changeTime = changeTime;
    }

    public ChangeFrom getChangeFrom() {
        return changeFrom;
    }

    public void setChangeFrom(ChangeFrom changeFrom) {
        this.changeFrom = changeFrom;
    }

    public NextLevel getNextLevel() {
        return nextLevel;
    }

    public void setNextLevel(NextLevel nextLevel) {
        this.nextLevel = nextLevel;
    }

    public Number getPrevLevelThreshold() {
        return prevLevelThreshold;
    }

    public void setPrevLevelThreshold(Number prevLevelThreshold) {
        this.prevLevelThreshold = prevLevelThreshold;
    }

    public Number getCurrentLevelProgress() {
        return currentLevelProgress;
    }

    public void setCurrentLevelProgress(Number currentLevelProgress) {
        this.currentLevelProgress = currentLevelProgress;
    }

    public Number getNextLevelProgress() {
        return nextLevelProgress;
    }

    public void setNextLevelProgress(Number nextLevelProgress) {
        this.nextLevelProgress = nextLevelProgress;
    }

    public List<CurrentBenefitList> getCurrentBenefitList() {
        return currentBenefitList;
    }

    public void setCurrentBenefitList(List<CurrentBenefitList> currentBenefitList) {
        this.currentBenefitList = currentBenefitList;
    }
}
