package cn.com.duiba.customer.link.project.api.remoteservice.app99349.dto;

/**
 * QQ小程序大单购活动订单信息查询请求
 * 
 * @author zhangdaqing
 * @date 2025/1/20
 */
public class QQBigBuyInfoReq {
    
    private final String openId;
    
    /**
     * 构造函数
     * @param openId 用户OpenID
     */
    public QQBigBuyInfoReq(String openId) {
        if (openId == null || openId.trim().isEmpty()) {
            throw new IllegalArgumentException("OpenID不能为空");
        }
        this.openId = openId.trim();
    }
    
    /**
     * 获取用户OpenID
     * @return OpenID
     */
    public String getOpenId() {
        return openId;
    }
    
    @Override
    public String toString() {
        return "QQBigBuyInfoReq{" +
                "openId='" + openId + '\'' +
                '}';
    }
}
