package cn.com.duiba.customer.link.project.api.remoteservice.app84373;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.customer.link.project.api.remoteservice.app84373.param.QuerySignParam;
import cn.com.duiba.customer.link.project.api.remoteservice.app84373.param.UserSignParam;
import cn.com.duiba.customer.link.project.api.remoteservice.app84373.response.AccessTokenDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app84373.response.QuerySignResponse;
import cn.com.duiba.customer.link.project.api.remoteservice.app84373.response.UserSignResponse;

/**
 * 联想接口
 *
 * @author songp
 * @date 2025/2/5 2:07 下午
 */
public interface RemoteLianXiangService {

    /**
     * 查询授权token
     *
     * @return 授权token
     * @throws BizException 业务异常
     */
    AccessTokenDto getAccessToken() throws BizException;

    /**
     * 签到接口
     *
     * @param param 请求参数
     * @return 签到结果
     * @throws BizException 业务异常
     */
    UserSignResponse userSign(UserSignParam param) throws BizException;

    /**
     * 查询签到状态
     *
     * @param param 请求参数
     * @return 签到状态
     * @throws BizException 业务异常
     */
    QuerySignResponse querySignStatus(QuerySignParam param) throws BizException;
}
