/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.customer.link.project.api.remoteservice.app99349.dto;

import cn.com.duiba.customer.link.project.api.remoteservice.app99349.dto.QQBigBuyOrderInfo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QQBigBuyInfoResp {
    private final int returnCode;
    private final String result;
    private final List<QQBigBuyOrderInfo> orderInfoList;

    public QQBigBuyInfoResp(int returnCode, String result) {
        this.returnCode = returnCode;
        this.result = result;
        this.orderInfoList = this.parseOrderInfoList(result);
    }

    public boolean isSuccess() {
        return this.returnCode == 0;
    }

    public boolean isFailure() {
        return this.returnCode != 0;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String getResult() {
        return this.result;
    }

    public List<QQBigBuyOrderInfo> getOrderInfoList() {
        return this.orderInfoList;
    }

    public String getErrorMessage() {
        if (this.isFailure()) {
            return this.result != null ? this.result : "\u67e5\u8be2\u5927\u5355\u8d2d\u6d3b\u52a8\u8ba2\u5355\u4fe1\u606f\u5931\u8d25";
        }
        return null;
    }

    private List<QQBigBuyOrderInfo> parseOrderInfoList(String resultJson) {
        if (resultJson == null || resultJson.trim().isEmpty()) {
            return Collections.emptyList();
        }
        try {
            JSONArray jsonArray = JSON.parseArray((String)resultJson);
            ArrayList<QQBigBuyOrderInfo> orderList = new ArrayList<QQBigBuyOrderInfo>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject orderJson = jsonArray.getJSONObject(i);
                String orderId = orderJson.getString("OrderID");
                String giftCode = orderJson.getString("GiftCode");
                String acceptDate = orderJson.getString("AcceptDate");
                orderList.add(new QQBigBuyOrderInfo(orderId, giftCode, acceptDate));
            }
            return orderList;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public static QQBigBuyInfoResp fromJsonString(String jsonString) {
        try {
            JSONObject json = JSONObject.parseObject((String)jsonString);
            int returnCode = json.getIntValue("Return");
            String result = json.getString("Result");
            return new QQBigBuyInfoResp(returnCode, result);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u54cd\u5e94JSON\u683c\u5f0f: " + jsonString, e);
        }
    }

    public String toString() {
        return "QQBigBuyInfoResp{returnCode=" + this.returnCode + ", result='" + this.result + '\'' + ", orderInfoList=" + this.orderInfoList + ", isSuccess=" + this.isSuccess() + '}';
    }
}

