package cn.com.duiba.customer.link.project.api.remoteservice.app96254.dto;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 查询会正向订单以及子订单item
 *
 * @author songp
 * @date 2024/1/10 5:11 下午
 */
public class OrderQueryItem {

    /**
     * 消费门店类型code
     */
    private String shopTypeCode;

    /**
     * 渠道类型
     * YOUZAN: 有赞微商城
     * POS : 线下
     * TAOBAO : 淘宝
     * JD : 京东
     */
    private String channelType;

    /**
     * 应付金额
     */
    private Double totalFee;

    /**
     * 正常单时，代表实付金额
     */
    private String payment;

    /**
     * 0<=折扣率 <=1
     */
    private Double discountRate;

    /**
     * 折扣金额
     */
    private Double discountFee;

    /**
     * 扩展字段 map
     */
    private String customizedProperties;

    /**
     * 会员类型,固定值: qiaqia
     */
    private String memberType;

    /**
     * 客户编号
     */
    private String customerNo;

    /**
     * 订单ID
     */
    private String orderId;

    /**
     * 原始订单id
     */
    private String originOrderId;

    /**
     * 消费门店code
     */
    private String shopCode;

    /**
     * 消费门店名称
     */
    private String shopName;

    /**
     * 会员ID
     */
    private String memberId;

    /**
     * 商品总数
     */
    private Double totalQuantity;

    /**
     * 订单类型:正常单-NORMAL,退单-REFUND,赠品订单-GIFT。更多可以去字典表配置
     */
    private String orderType;

    /**
     * 订单状态:CREATED-下单,CANCELLED-订单取消,DELIVERED-已发货,CONFIRMED-卖家已确认,FINISHED-完成,REFUND_START-退款开始,REFUND_FINISHED-退款完成
     */
    private String orderStatus;

    /**
     * 运费
     */
    private Double freight;

    /**
     * 收货人姓名
     */
    private String receiverName;

    /**
     * 收货人手机
     */
    private String receiverMobile;

    /**
     * 收货人固定电话
     */
    private String receiverTelephone;

    /**
     * 收货人省份
     */
    private String receiverProvince;

    /**
     * 收货人城市
     */
    private String receiverCity;

    /**
     * 收货人街区
     */
    private String receiverDistrict;

    /**
     * 收货人地址
     */
    private String receiverAddress;

    /**
     * 收货人邮编
     */
    private String receiverZipCode;

    /**
     * 导购编码
     */
    private String guideCode;

    /**
     * 备注
     */
    private String description;

    /**
     * 是否计算积分. 0-不计算积分, 1- 计算积分
     */
    private String pointFlag;

    /**
     * 是否是内部订单. Y:否 N:是 . 默认为N
     */
    private String isInternal;

    /**
     * id
     */
    private String id;

    /**
     * 订单付款时间 格式: yyyy-MM-dd'T'HH:mm:ss.SSSXXX
     */
    private LocalDateTime payTime;

    /**
     * 订单发货时间 格式: yyyy-MM-dd'T'HH:mm:ss.SSSXXX
     */
    private LocalDateTime shippingTime;

    /**
     * 订单收货时间 格式: yyyy-MM-dd'T'HH:mm:ss.SSSXXX
     */
    private LocalDateTime receiveTime;

    /**
     * 订单换货时间 格式: yyyy-MM-dd'T'HH:mm:ss.SSSXXX
     */
    private LocalDateTime exchangeTime;

    /**
     * 订单退货时间 格式: yyyy-MM-dd'T'HH:mm:ss.SSSXXX
     */
    private LocalDateTime refundTime;

    /**
     * 订单完成时间, 格式: yyyy-MM-dd'T'HH:mm:ss.SSSXXX
     */
    private LocalDateTime finishTime;

    /**
     * 下单时间 格式: yyyy-MM-dd'T'HH:mm:ss.SSSXXX
     */
    private LocalDateTime orderTime;

    /**
     * 更新时间, 格式: yyyy-MM-dd'T'HH:mm:ss.SSSXXX
     */
    private LocalDateTime updateTime;

    /**
     * 数据同步时间,格式: yyyy-MM-dd'T'HH:mm:ss.SSSXXX
     */
    private LocalDateTime lastSync;

    /**
     * 子订单列表
     */
    private List<OrderItemDto> orderItems;

    public String getShopTypeCode() {
        return shopTypeCode;
    }

    public void setShopTypeCode(String shopTypeCode) {
        this.shopTypeCode = shopTypeCode;
    }

    public String getChannelType() {
        return channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public Double getTotalFee() {
        return totalFee;
    }

    public void setTotalFee(Double totalFee) {
        this.totalFee = totalFee;
    }

    public String getPayment() {
        return payment;
    }

    public void setPayment(String payment) {
        this.payment = payment;
    }

    public Double getDiscountRate() {
        return discountRate;
    }

    public void setDiscountRate(Double discountRate) {
        this.discountRate = discountRate;
    }

    public Double getDiscountFee() {
        return discountFee;
    }

    public void setDiscountFee(Double discountFee) {
        this.discountFee = discountFee;
    }

    public String getCustomizedProperties() {
        return customizedProperties;
    }

    public void setCustomizedProperties(String customizedProperties) {
        this.customizedProperties = customizedProperties;
    }

    public String getMemberType() {
        return memberType;
    }

    public void setMemberType(String memberType) {
        this.memberType = memberType;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getOriginOrderId() {
        return originOrderId;
    }

    public void setOriginOrderId(String originOrderId) {
        this.originOrderId = originOrderId;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getMemberId() {
        return memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public Double getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(Double totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Double getFreight() {
        return freight;
    }

    public void setFreight(Double freight) {
        this.freight = freight;
    }

    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public String getReceiverMobile() {
        return receiverMobile;
    }

    public void setReceiverMobile(String receiverMobile) {
        this.receiverMobile = receiverMobile;
    }

    public String getReceiverTelephone() {
        return receiverTelephone;
    }

    public void setReceiverTelephone(String receiverTelephone) {
        this.receiverTelephone = receiverTelephone;
    }

    public String getReceiverProvince() {
        return receiverProvince;
    }

    public void setReceiverProvince(String receiverProvince) {
        this.receiverProvince = receiverProvince;
    }

    public String getReceiverCity() {
        return receiverCity;
    }

    public void setReceiverCity(String receiverCity) {
        this.receiverCity = receiverCity;
    }

    public String getReceiverDistrict() {
        return receiverDistrict;
    }

    public void setReceiverDistrict(String receiverDistrict) {
        this.receiverDistrict = receiverDistrict;
    }

    public String getReceiverAddress() {
        return receiverAddress;
    }

    public void setReceiverAddress(String receiverAddress) {
        this.receiverAddress = receiverAddress;
    }

    public String getReceiverZipCode() {
        return receiverZipCode;
    }

    public void setReceiverZipCode(String receiverZipCode) {
        this.receiverZipCode = receiverZipCode;
    }

    public String getGuideCode() {
        return guideCode;
    }

    public void setGuideCode(String guideCode) {
        this.guideCode = guideCode;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPointFlag() {
        return pointFlag;
    }

    public void setPointFlag(String pointFlag) {
        this.pointFlag = pointFlag;
    }

    public String getIsInternal() {
        return isInternal;
    }

    public void setIsInternal(String isInternal) {
        this.isInternal = isInternal;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LocalDateTime getPayTime() {
        return payTime;
    }

    public void setPayTime(LocalDateTime payTime) {
        this.payTime = payTime;
    }

    public LocalDateTime getShippingTime() {
        return shippingTime;
    }

    public void setShippingTime(LocalDateTime shippingTime) {
        this.shippingTime = shippingTime;
    }

    public LocalDateTime getReceiveTime() {
        return receiveTime;
    }

    public void setReceiveTime(LocalDateTime receiveTime) {
        this.receiveTime = receiveTime;
    }

    public LocalDateTime getExchangeTime() {
        return exchangeTime;
    }

    public void setExchangeTime(LocalDateTime exchangeTime) {
        this.exchangeTime = exchangeTime;
    }

    public LocalDateTime getRefundTime() {
        return refundTime;
    }

    public void setRefundTime(LocalDateTime refundTime) {
        this.refundTime = refundTime;
    }

    public LocalDateTime getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(LocalDateTime finishTime) {
        this.finishTime = finishTime;
    }

    public LocalDateTime getOrderTime() {
        return orderTime;
    }

    public void setOrderTime(LocalDateTime orderTime) {
        this.orderTime = orderTime;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public LocalDateTime getLastSync() {
        return lastSync;
    }

    public void setLastSync(LocalDateTime lastSync) {
        this.lastSync = lastSync;
    }

    public List<OrderItemDto> getOrderItems() {
        return orderItems;
    }

    public void setOrderItems(List<OrderItemDto> orderItems) {
        this.orderItems = orderItems;
    }
}
