package cn.com.duiba.customer.link.project.api.remoteservice.app98604.dto.req;

import cn.com.duiba.customer.link.project.api.remoteservice.app98604.dto.ConfirmTransferNotifyBody;

/**
 * 微信转账回调
 */
public class ConfirmTransferNotifyRequest {
    /**
     * 验签的“微信支付平台证书”所对应的平台证书序列号
     * Wechatpay-Serial(从请求头拿)
     */
    private String wechatpaySerial;
    /**
     * 验签的签名值
     * Wechatpay-Signature(从请求头拿)
     */
    private String wechatpaySignature;
    /**
     * 验签的时间戳
     * Wechatpay-Timestamp(从请求头拿)
     */
    private String wechatpayTimestamp;
    /**
     * 验签的随机字符串
     * Wechatpay-Nonce(从请求头拿)
     */
    private String wechatpayNonce;
    /**
     * 原始body参数,不要序列化后Str,容易造成验签失败
     *
     * @see ConfirmTransferNotifyBody
     */
    private String originBody;

    public String getWechatpaySerial() {
        return wechatpaySerial;
    }

    public void setWechatpaySerial(String wechatpaySerial) {
        this.wechatpaySerial = wechatpaySerial;
    }

    public String getWechatpaySignature() {
        return wechatpaySignature;
    }

    public void setWechatpaySignature(String wechatpaySignature) {
        this.wechatpaySignature = wechatpaySignature;
    }

    public String getWechatpayTimestamp() {
        return wechatpayTimestamp;
    }

    public void setWechatpayTimestamp(String wechatpayTimestamp) {
        this.wechatpayTimestamp = wechatpayTimestamp;
    }

    public String getWechatpayNonce() {
        return wechatpayNonce;
    }

    public void setWechatpayNonce(String wechatpayNonce) {
        this.wechatpayNonce = wechatpayNonce;
    }

    public String getOriginBody() {
        return originBody;
    }

    public void setOriginBody(String originBody) {
        this.originBody = originBody;
    }
}
