
package cn.com.duiba.customer.link.project.api.remoteservice.app98604.dto.req;

import cn.com.duiba.customer.link.project.api.remoteservice.app98604.dto.TransferDetailInput;

import java.util.ArrayList;
import java.util.List;


/**
 * InitiateBatchTransferRequest
 */
public class InitiateBatchTransferRequest {
    /**
     * 必填
     * 商户appid 说明：申请商户号的appid或商户号绑定的appid（企业号corpid即为此appid）
     */
    private String appid;

    /**
     * 必填
     * 商家批次单号 说明：商户系统内部的商家批次单号，要求此参数只能由数字、大小写字母组成，在商户系统内部唯一
     */
    private String out_batch_no;

    /**
     * 必填
     * 批次名称 说明：该笔批量转账的名称
     */
    private String batch_name;

    /**
     * 必填
     * 批次备注 说明：转账说明，UTF8编码，最多允许32个字符
     */
    private String batch_remark;

    /**
     * 必填
     * 转账总金额 说明：转账金额单位为“分”。转账总金额必须与批次内所有明细转账金额之和保持一致，否则无法发起转账操作
     */
    private Long total_amount;

    /**
     * 必填
     * 转账总笔数 说明：一个转账批次单最多发起一千笔转账。转账总笔数必须与批次内所有明细之和保持一致，否则无法发起转账操作
     */
    private Integer total_num;

    /**
     * 必填
     * 转账明细列表 说明：发起批量转账的明细列表，最多一千笔
     */
    private List<TransferDetailInput> transfer_detail_list = new ArrayList<TransferDetailInput>();

    /**
     * 转账场景ID 说明：该批次转账使用的转账场景，如不填写则使用商家的默认场景，如无默认场景可为空，可前往“商家转账到零钱-前往功能”中申请。 如：1001-现金营销
     */
    private String transfer_scene_id;

    /**
     * 通知地址 说明：异步接收微信支付结果通知的回调地址，通知url必须为公网可访问的url，必须为https，不能携带参数。
     */
    private String notify_url;

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getOut_batch_no() {
        return out_batch_no;
    }

    public void setOut_batch_no(String out_batch_no) {
        this.out_batch_no = out_batch_no;
    }

    public String getBatch_name() {
        return batch_name;
    }

    public void setBatch_name(String batch_name) {
        this.batch_name = batch_name;
    }

    public String getBatch_remark() {
        return batch_remark;
    }

    public void setBatch_remark(String batch_remark) {
        this.batch_remark = batch_remark;
    }

    public Long getTotal_amount() {
        return total_amount;
    }

    public void setTotal_amount(Long total_amount) {
        this.total_amount = total_amount;
    }

    public Integer getTotal_num() {
        return total_num;
    }

    public void setTotal_num(Integer total_num) {
        this.total_num = total_num;
    }

    public List<TransferDetailInput> getTransfer_detail_list() {
        return transfer_detail_list;
    }

    public void setTransfer_detail_list(List<TransferDetailInput> transfer_detail_list) {
        this.transfer_detail_list = transfer_detail_list;
    }

    public String getTransfer_scene_id() {
        return transfer_scene_id;
    }

    public void setTransfer_scene_id(String transfer_scene_id) {
        this.transfer_scene_id = transfer_scene_id;
    }

    public String getNotify_url() {
        return notify_url;
    }

    public void setNotify_url(String notify_url) {
        this.notify_url = notify_url;
    }
}
