/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.dubbo;

import cn.com.duiba.service.exception.ServiceInternalException;
import java.io.Serializable;

public class DubboResult<T>
implements Serializable {
    private static final long serialVersionUID = -6978963188996203322L;
    private static final String CODE_SERVICE_INTERNAL_EXCEPTION = "0102";
    private static final String SUCCESS = "success";
    private static final String FAIL = "fail";
    private boolean isSuccess = true;
    private String msg;
    private String returnCode;
    private T result;

    public static <T> DubboResult<T> successResult(T result) {
        DubboResult<T> dubboResult = new DubboResult<T>();
        dubboResult.setResult(result);
        dubboResult.setSuccess(true);
        dubboResult.setMsg(SUCCESS);
        return dubboResult;
    }

    public static <T> DubboResult<T> failResult(String msg) {
        DubboResult<T> dubboResult = new DubboResult<T>();
        dubboResult.setSuccess(false);
        dubboResult.setMsg(msg);
        return dubboResult;
    }

    public DubboResult() {
    }

    public DubboResult(boolean isSuccess, String msg, T result) {
        this.isSuccess = isSuccess;
        this.msg = msg;
        this.result = result;
    }

    public static DubboResult builder() {
        return new DubboResult();
    }

    public DubboResult isSuccess(boolean isSuccess) {
        this.isSuccess = isSuccess;
        return this;
    }

    public DubboResult msg(String msg) {
        this.msg = msg;
        return this;
    }

    public DubboResult result(T result) {
        this.result = result;
        return this;
    }

    public DubboResult build() {
        return this;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getResult() {
        if (!this.isSuccess()) {
            if (this.returnCode == null || this.returnCode.equals("")) {
                throw new RuntimeException(this.msg);
            }
            if (this.returnCode.length() >= 6 && this.returnCode.substring(2, 6).equals(CODE_SERVICE_INTERNAL_EXCEPTION)) {
                throw new ServiceInternalException("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
            }
            throw new RuntimeException(this.msg);
        }
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setSuccess(boolean success) {
        this.isSuccess = success;
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public static void main(String[] args) {
        DubboResult<String> dubboResult = DubboResult.mockDubboResult();
        if (dubboResult.isSuccess()) {
            // empty if block
        }
    }

    private static DubboResult<String> mockDubboResult() {
        return new DubboResult<String>();
    }
}

