/**
 * Project Name:credits
 * File Name:ActivityLotteryFlowworkService.java
 * Package Name:cn.com.duiba.dcommons.flowword
 * Date:2016年8月1日上午11:23:55
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/
package cn.com.duiba.dcommons.flowwork;

import java.io.Serializable;
import java.util.List;

/**
 * ClassName:ActivityLotteryFlowworkService <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:	 2016年8月1日 上午11:23:55 <br/>
 * @author   zp
 * @version  
 * @since	JDK 1.6
 * @see 	 
 */
public interface ActivityLotteryFlowworkService {

	/**
	 * 插入到兑换记录
	 * @author zp
	 * @param consumerId
	 * @param orderNum
	 * @param relationType
	 * @param prizeType
	 * @return
	 * @since JDK 1.6
	 */
	public Long insertCosumerExchanageRecord(Long consumerId, String orderNum, String relationType,String prizeType);
	
	/**
	 * 优惠券自动领奖
	 * @author zp
	 * @param orderId
	 * @param consumer
	 * @param app
	 * @param requestParams
	 * @since JDK 1.6
	 */
	public void autoTakePrize(String orderNum,Long consumerId,Long appId,String ip,String userAgent);
	
	/**
	 * 查询兑换记录id
	 * @author zp
	 * @param consumerId
	 * @param orderNum
	 * @param relationType
	 * @param prizeType
	 * @return
	 * @since JDK 1.6
	 */
	public Long getCosumerExchanageRecord(Long consumerId, String orderNum, String relationType);
	
	/**
	 * 查询中奖广播信息
	 * @author zp
	 * @param orderId
	 * @param consumer
	 * @param app
	 * @param requestParams
	 * @since JDK 1.6
	 */
	public List<NotityQueue> findNotifyQueue();
	
	/**
	 * 插入pv uv 日志信息 
	 * @author zp
	 * @param orderId
	 * @param consumer
	 * @param app
	 * @param requestParams
	 * @since JDK 1.6
	 */
	public void printAccessLog (Long consumerId,Long appId,Long activityId,String ip,String ua);
	
	public static class NotityQueue implements Serializable{
		private static final long serialVersionUID = 1L;

		//订单id
		private String brief;
		//订单状态
		private String prizeName;
		
		public String getBrief() {
			return brief;
		}
		public void setBrief(String brief) {
			this.brief = brief;
		}
		public String getPrizeName() {
			return prizeName;
		}
		public void setPrizeName(String prizeName) {
			this.prizeName = prizeName;
		}
	}
}

