package cn.com.duiba.dcommons.flowwork;

import java.util.List;

public interface AmbPostsaleFlowworkService {

	/**
	 * 开发者后台用 同意售后接口 需要参数，售后订单ID，备注，以及操作appId
	 */
	public boolean dlpAgreePostsale(Long postsaleOrderId, String dlpRemark, Long operateAppId);

	/**
	 * 开发者后台用 拒绝售后接口 需要参数，售后订单ID，备注，以及操作appId
	 */
	public boolean dlpRejectPostsale(Long postsaleOrderId, String dlpRemark, Long operateAppId);

	/**
	 * 开发者后台用 完成售后接口 需要参数，售后订单ID，以及操作appId
	 */
	public boolean dlpCompletePostsale(Long postsaleOrderId, Long operateAppId);

	/**
	 * 管理员后台用 同意售后接口 需要参数，售后订单ID，备注，以及操作appId
	 */
	public boolean mngAgreePostsale(Long postsaleOrderId, String dlpRemark);

	/**
	 * 管理员后台用 拒绝售后接口 需要参数，售后订单ID，备注，以及操作appId
	 */
	public boolean mngRejectPostsale(Long postsaleOrderId, String dlpRemark);

	/**
	 * 管理员后台用 完成售后接口 需要参数，售后订单ID，以及操作appId
	 */
	public boolean mngCompletePostsale(Long postsaleOrderId);
	
	/**
	 * 管理员后台点击退款 则售后订单标为成功，需要参数，售后订单ID
	 */
	public boolean mngDoSuccessPostsales(List<Long> postsaleOrderIds);
}
