package cn.com.duiba.dcommons.flowwork;

/**
 * 数据同步服务接口
 * 
 * @author houwen
 */
public interface DataSyncService {

	/**
	 * 用户兑换记录数据同步
	 * 
	 * @param orderId
	 * @param consumerId
	 * @return
	 */
	public boolean crecordSync(Long crecordId, Long consumerId);

	/**
	 * 主订单数据同步
	 * 
	 * @param orderId
	 *            订单ID
	 * @param consumerId
	 *            用户ID
	 * @return
	 */
	public boolean mainOrderSync(Long orderId, Long consumerId);

	/**
	 * 活动工具数据同步
	 * 
	 * @param orderId
	 * @param consumerId
	 * @return
	 */
	public boolean hdtoolOrderSync(Long orderId, Long consumerId);

	/**
	 * 竞猜活动订单数据同步
	 * 
	 * @param orderId
	 * @param consumerId
	 * @return
	 */
	public boolean guessOrderSync(Long orderId, Long consumerId);

	/**
	 * 游戏订单数据同步
	 * 
	 * @param orderId
	 * @param consumerId
	 * @return
	 */
	public boolean gameOrderSync(Long orderId, Long consumerId);

	/**
	 * 秒杀订单数据同步
	 * 
	 * @param orderId
	 * @param consumerId
	 * @return
	 */
	public boolean seckillOrderSync(Long orderId, Long consumerId);

	/**
	 * quizz数据同步
	 * 
	 * @param orderId
	 * @param consumerId
	 * @return
	 */
	public boolean quizzOrderSync(Long orderId, Long consumerId);

}
