package cn.com.duiba.dcommons.flowwork;

import cn.com.duiba.dcommons.exception.ReadableMessageException;


/**
 * 主订单提供查询的Service
 * @author xuhengfei
 *
 */
public interface MainOrderFlowworkService {
	/**
	 * 审核拒绝
	 * @param orderId
	 * @return
	 * @throws Exception
	 */
	public boolean doAuditReject(Long orderId) throws ReadableMessageException;
	/**
	 * 审核通过
	 * @param orderId
	 * @return
	 * @throws Exception
	 */
	public boolean doAuditPass(Long orderId) throws ReadableMessageException;
	/**
	 * 执行发货操作
	 * @param orderId
	 * @return
	 * @throws ReadableMessageException
	 */
	public boolean executeObjectSend(Long orderId,String expressName,String expressId) throws ReadableMessageException;
	/**
	 * 开发者取消自有实物订单
	 * @param reason
	 * @return
	 * @throws ReadableMessageException
	 */
	public boolean executeObjectCancel(Long orderId, String reason) throws ReadableMessageException ;
	/**
	 * 执行手动开奖发货流程
	 * @param shipInfo
	 * @return
	 * @throws ReadableMessageException
	 */
	public boolean executeManualLotterySend(Long orderId,String shipInfo) throws ReadableMessageException;
	/**
	 * 开发者强制   虚拟商品成功
	 * @param orderId
	 * @return
	 * @throws Exception
	 */
	public boolean forceVirtual2SupplierSuccess(Long orderId,String error4admin,String error4developer,String error4consumer) throws ReadableMessageException;
	/**
	 * 开发者   强制   虚拟商品失败
	 */
	public boolean forceVirtual2SupplierFail(Long orderId,String error4admin,String error4developer,String error4consumer) throws ReadableMessageException;
	
	/**
	 * 强制扣积分成功，并且走后续流程
	 * 
	 * 主要使用于秒杀商品，强制走后续流程
	 * @param orderId
	 * @return
	 * @throws ReadableMessageException
	 */
	public boolean killOrderMakeSuccess(Long orderId) throws ReadableMessageException;
	/**
	 * 管理员秒杀订单强制失败
	 * 
	 * @param orderId
	 * @return
	 * @throws ReadableMessageException
	 */
	public boolean killOrderMakeFail(Long orderId) throws ReadableMessageException;
	/**
	 * 管理员取消订单
	 * @param orderId
	 * @return
	 * @throws ReadableMessageException
	 */
	public boolean adminCanceOrder(Long orderId,String reason) throws ReadableMessageException;
	
	
	/****
	 * 管理 员   强制  上游 兑换成功 
	 * @param orderId
	 * @param error4admin
	 * @param error4developer
	 * @param error4consumer
	 * @return
	 * @throws ReadableMessageException
	 */
	public boolean mngForceSupplierSuccess(Long orderId,String error4admin,String error4developer,String error4consumer) throws ReadableMessageException;
	/****
	 * 管理 员强制上游兑换失败
	 * @param orderId
	 * @param error4admin
	 * @param error4developer
	 * @param error4consumer
	 * @return
	 * @throws ReadableMessageException
	 */
	public boolean mngForceSupplierFail(Long orderId,String error4admin,String error4developer,String error4consumer) throws ReadableMessageException;
	
	
	public boolean forceMakeSuccess(Long orderId,String error4admin,String error4developer, String error4consumer) throws ReadableMessageException ;
	
	public boolean forceMakeFail(Long orderId,String error4admin,String error4developer, String error4consumer)throws ReadableMessageException;
	
	public boolean updateAllowInputAndTips(Long orderId, Long consumerId, Boolean allowInput, String allowInputTips) throws ReadableMessageException;

}
