/**
 * Project Name:dcommons-flowwork-client
 * File Name:RemotePlatformCouponGoodsTakeOrderService.java
 * Package Name:cn.com.duiba.dcommons.flowwork
 * Date:2016年6月28日下午8:13:19
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.dcommons.flowwork;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;


/**
 * ClassName:RemotePlatformCouponGoodsTakeOrderService <br/>
 * Function: 平台券商品下单接口 <br/>
 * Date:     2016年6月28日 下午8:13:19 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemotePlatformCouponGoodsTakeOrderService {
    
    public TakeOrderResult takeOrder(PcgOrderParam param);
    
    public ScanOrderResult scanOrder(Long orderId,Long consumerId);
    
    public static class TakeOrderResult implements Serializable{
        private static final long serialVersionUID = 1L;
        //订单是否创建成功
        private boolean success=false;
        //是否需要回滚返还积分，优惠劵，库存等
        private boolean needRollback=false;
        
        private Long orderId;

        
        public boolean isSuccess() {
            return success;
        }

        
        public void setSuccess(boolean success) {
            this.success = success;
        }

        
        public boolean isNeedRollback() {
            return needRollback;
        }

        
        public void setNeedRollback(boolean needRollback) {
            this.needRollback = needRollback;
        }

        
        public Long getOrderId() {
            return orderId;
        }

        
        public void setOrderId(Long orderId) {
            this.orderId = orderId;
        }
        
    }
    
    public static class PcgOrderParam implements Serializable{
        private static final long serialVersionUID = 1L;
        private String ip;
        private String orderNum;
        private Long consumerId;
        private Long appId;
        private Long couponId;
        private Long credits;
        private Long pcgId;
        private Integer facePrice;
        private String brief;
        
        private String userAgent;
        private Map<String, String> cookies;
        //优惠券过期时间
        private Date overDue;
        //relationtype relationid
        
        public String getIp() {
            return ip;
        }
        
        public void setIp(String ip) {
            this.ip = ip;
        }
        
        public String getOrderNum() {
            return orderNum;
        }
        
        public void setOrderNum(String orderNum) {
            this.orderNum = orderNum;
        }
        
        public Long getConsumerId() {
            return consumerId;
        }
        
        public void setConsumerId(Long consumerId) {
            this.consumerId = consumerId;
        }
        
        public Long getAppId() {
            return appId;
        }
        
        public void setAppId(Long appId) {
            this.appId = appId;
        }
        
        public Long getCouponId() {
            return couponId;
        }
        
        public void setCouponId(Long couponId) {
            this.couponId = couponId;
        }
        
        public Long getCredits() {
            return credits;
        }
        
        public void setCredits(Long credits) {
            this.credits = credits;
        }
        
        public Long getPcgId() {
            return pcgId;
        }
        
        public void setPcgId(Long pcgId) {
            this.pcgId = pcgId;
        }
        
        public Integer getFacePrice() {
            return facePrice;
        }
        
        public void setFacePrice(Integer facePrice) {
            this.facePrice = facePrice;
        }
        
        public String getBrief() {
            return brief;
        }
        
        public void setBrief(String brief) {
            this.brief = brief;
        }

        
        public String getUserAgent() {
            return userAgent;
        }

        
        public void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        
        public Map<String, String> getCookies() {
            return cookies;
        }

        
        public void setCookies(Map<String, String> cookies) {
            this.cookies = cookies;
        }

        
        public Date getOverDue() {
            return overDue;
        }

        
        public void setOverDue(Date overDue) {
            this.overDue = overDue;
        }

    }

    public static class ScanOrderResult implements Serializable{
    	
        private static final long serialVersionUID = 1L;
        
        //订单id
        private Long orderId;
        //订单状态
        private String status;
		//平台券id
        private Long pcgId;
        //用户id
        private Long consumerId;
        //券库id
        private Long couponId;
        //appId
        private Long appId;
        
        //error4Admin
        private String error4Admin;
        
        public Long getAppId() {
			return appId;
		}
		public void setAppId(Long appId) {
			this.appId = appId;
		}
		public Long getOrderId() {
			return orderId;
		}
		public void setOrderId(Long orderId) {
			this.orderId = orderId;
		}
		public String getStatus() {
			return status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public Long getPcgId() {
			return pcgId;
		}
		public void setPcgId(Long pcgId) {
			this.pcgId = pcgId;
		}
		public Long getConsumerId() {
			return consumerId;
		}
		public void setConsumerId(Long consumerId) {
			this.consumerId = consumerId;
		}
		public Long getCouponId() {
			return couponId;
		}
		public void setCouponId(Long couponId) {
			this.couponId = couponId;
		}
		public String getError4Admin() {
			return error4Admin;
		}
		public void setError4Admin(String error4Admin) {
			this.error4Admin = error4Admin;
		}
    }
    
}

