package cn.com.duiba.dcommons.flowwork;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public interface SeckillFlowworkService {

	public boolean updateAddress(Long consumerId, String addrName, String addrProvince, String addrCity, String addrPhone, String addrArea, String addrDetail);

	public SeckillExchangeResult exchange4Seckill(SecRequestParams srParam, ExchangeParams eParams);

	public String findConsumer(Long id);
	
	public static class SecRequestParams implements Serializable {
		private static final long serialVersionUID = 8192091634042503319L;
		
		private String userAgent;
		private Long consumerId;
		private String ip;
		private Map<String, String> cookies = new HashMap<String, String>();

		public String getUserAgent() {
			return userAgent;
		}

		public void setUserAgent(String userAgent) {
			this.userAgent = userAgent;
		}

		public Long getConsumerId() {
			return consumerId;
		}

		public void setConsumerId(Long consumerId) {
			this.consumerId = consumerId;
		}

		public String getIp() {
			return ip;
		}

		public void setIp(String ip) {
			this.ip = ip;
		}

		public Map<String, String> getCookies() {
			return cookies;
		}

		public void setCookies(Map<String, String> cookies) {
			this.cookies = cookies;
		}

	}

	public static class ExchangeParams implements Serializable {
		private static final long serialVersionUID = -1704083898235026766L;
		
		private Long credits;
		private Long itemId;
		private Long appItemId;
		private Long operatingActivityId;
		private Long consumerId;
		private Long appId;

		public Long getAppId() {
			return appId;
		}

		public void setAppId(Long appId) {
			this.appId = appId;
		}

		public Long getCredits() {
			return credits;
		}

		public void setCredits(Long credits) {
			this.credits = credits;
		}

		public Long getItemId() {
			return itemId;
		}

		public void setItemId(Long itemId) {
			this.itemId = itemId;
		}

		public Long getAppItemId() {
			return appItemId;
		}

		public void setAppItemId(Long appItemId) {
			this.appItemId = appItemId;
		}

		public Long getOperatingActivityId() {
			return operatingActivityId;
		}

		public void setOperatingActivityId(Long operatingActivityId) {
			this.operatingActivityId = operatingActivityId;
		}

		public Long getConsumerId() {
			return consumerId;
		}

		public void setConsumerId(Long consumerId) {
			this.consumerId = consumerId;
		}

	}

	public static class SeckillExchangeResult implements Serializable {
		private static final long serialVersionUID = 2019915038297296387L;
		
		private boolean success;
		private String errorMsg;
		private Long orderId;
		private String url;

		public SeckillExchangeResult(boolean success, Long orderId, String url) {
			this.success = success;
			this.orderId = orderId;
			this.url = url;
		}

		public SeckillExchangeResult(boolean success, String errorMsg) {
			this.success = success;
			this.errorMsg = errorMsg;
		}

		public boolean isSuccess() {
			return success;
		}

		public void setSuccess(boolean success) {
			this.success = success;
		}

		public Long getOrderId() {
			return orderId;
		}

		public void setOrderId(Long orderId) {
			this.orderId = orderId;
		}

		public String getUrl() {
			return url;
		}

		public void setUrl(String url) {
			this.url = url;
		}

		public String getErrorMsg() {
			return errorMsg;
		}

		public void setErrorMsg(String errorMsg) {
			this.errorMsg = errorMsg;
		}

	}
}
