package cn.com.duiba.dcs.metadata.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.dcs.metadata.api.dto.EventAttributeDTO;
import cn.com.duiba.dcs.metadata.api.param.EventAttributeQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @Description 事件属性相关
 * @Author dangcang
 * @Date 2022/2/7 2:37 下午
 **/
@AdvancedFeignClient
public interface RemoteEventAttributeService {

    /**
     * 分页查询事件属性
     * @param param
     * @return
     * @throws BizException
     */
    PageResponse<EventAttributeDTO> findEventAttribute(EventAttributeQueryParam param) throws BizException;

    /**
     * 根据事件id查询事件属性
     * @param eventId
     * @return
     * @throws BizException
     */
    EventAttributeDTO findById(Long eventId) throws BizException;
}