package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.developer.center.api.domain.dto.AppOtherDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.paramquery.CreateAppQueryParams;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by liuyao on 16/7/29.
 */
public interface RemoteAppService {
    /**
     * 创建App,注册时请不要调此服务,因为注册服务会自动完成app的创建
     * @param param
     * @return
     */
    public DubboResult<Long> CreateApp(CreateAppQueryParams param);

    /**
     * 获取App简单字段(可高并发)
     * @param id
     * @return
     */
    public DubboResult<AppSimpleDto> getSimpleApp(Long id);

    /**
     * 获取App不常用字段(可高并发)
     * @param id
     * @return
     */
    public DubboResult<AppOtherDto> getAppOtherProp(Long id);

}
