/**
 * Project Name:developer-center-api
 * File Name:BannerOrButtonEnum.java
 * Package Name:cn.com.duiba.developer.center.api.domain.enums
 * Date:2016年8月11日上午11:24:45
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.developer.center.api.domain.enums;

import org.apache.commons.lang.StringUtils;

/**
 * ClassName:BannerOrButtonEnum <br/>
 * app_banner.type字段枚举值
 * Date:     2016年8月11日 上午11:24:45 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public enum BannerOrButtonEnum implements EnumInterface {
    BANNER("banner", "banner类型"),

    BUTTON("button", "button类型");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private BannerOrButtonEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static BannerOrButtonEnum getByCode(String code) {
        for (BannerOrButtonEnum enumVal : BannerOrButtonEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }
}

