package cn.com.duiba.developer.center.api.domain.manager;

import cn.com.duiba.developer.center.api.domain.BaseDO;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.util.Date;

/**
 * Created by liuyao on 16/7/15.
 */
public class InternalLetterDO extends BaseDO{
    private static final long serialVersionUID = 2430169255827104466L;
    /**
     * 全员发送
     */
    public final static String Destinations_All = "all";
    public final static String Destinations_SPL_REX = ",";

    public final static int SendWay_RightAway = 0;
    public final static int SendWay_FixedTime = 1;

    public final static int SendStatue_NotPush = 0;
    public final static int SendStatue_Push = 1;



    private Long id;
    @Size(min=1,max=10,message = "用户名不能为空,且最长10个字符")
    private String send;

    @NotNull(message = "必须指定站内信的接收者")
    @Size(max=2000,message = "指定接受者过多,建议分多个批次推送站内信")
    @Pattern(regexp = "^all|[\\d,]*\\d$",message="指定接收者参数格式异常")
    private String destinations;

    private Boolean deleted;
    @Size(min = 1,max=20,message = "站内信名称不能为空,且最多为20个字符")
    private String title;
    @Size(min = 1,max=2500,message = "站内信内容详情过大,建议字符数控制在2000左右")
    private String content;
    @NotNull(message = "必须要指定提交方式")
    private Integer sendWay;
    private Date sendTime;
    private Integer sendStatue;
    @NotNull(message = "必须提交管理员Id")
    private Long adminId;
    private Date gmtCreate;
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSend() {
        return send;
    }

    public void setSend(String send) {
        this.send = send;
    }

    public String getDestinations() {
        return destinations;
    }

    public void setDestinations(String destinations) {
        this.destinations = destinations;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getSendWay() {
        return sendWay;
    }

    public void setSendWay(Integer sendWay) {
        this.sendWay = sendWay;
    }

    public Date getSendTime() {
        return sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public Integer getSendStatue() {
        return sendStatue;
    }

    public void setSendStatue(Integer sendStatue) {
        this.sendStatue = sendStatue;
    }

    public Long getAdminId() {
        return adminId;
    }

    public void setAdminId(Long adminId) {
        this.adminId = adminId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
