package cn.com.duiba.developer.center.api.remoteservice.floor;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.CreditsFloorSkinDto;
import cn.com.duiba.developer.center.api.domain.paramquery.FloorPageParams;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;

import java.util.List;

/**
 * 楼层代码服务
 */
public interface RemoteCreditsFloorSkinService {
    /**
     * 加载皮肤分页列表
     * @param params 分页请求参数
     */
    public DubboResult<PaginationVO<JSONObject>> getSkinPage(FloorPageParams params);
    /**
     * 新建一个楼层皮肤
     * @param dto
     * @return
     */
    public DubboResult<CreditsFloorSkinDto> insertFloorSkin(CreditsFloorSkinDto dto);

    /**
     * 更新一个楼层皮肤
     * @param dto 传入的新皮肤
     */
    public DubboResult<Integer> updateFloorSkin(CreditsFloorSkinDto dto);

    /**
     * 管理员端获取楼层分页列表
     * @param params 分页请求参数
     * @return 分页列表
     */
    public DubboResult<PaginationVO<JSONObject>> selectFloorSkins(FloorPageParams params);

    /**
     * 高并发访问接口:获取皮肤配置
     * @param id
     * @return
     */
    public DubboResult<CreditsFloorSkinDto> selectFloorSkinById(Long id);

    /**
     * 获取楼层编辑页回显数据
     * @param id 楼层id
     * @return 楼层配置
     */
    public DubboResult<JSONObject> getOneSkinConfig(Long id);

    /**
     * 开启或关闭定向开关
     * 1.已经有App使用的皮肤无法开启定向
     * 2.已经存在定向的皮肤无法关闭定向开关
     * @param id
     * @param isOpen
     * @return
     */
    public DubboResult<Boolean> switchSkinSpecify(Long id,Boolean isOpen);

    /**
     * 获取皮肤下所有的定向App
     * @param skinId
     * @return
     */
    public DubboResult<List<AppSimpleDto>> getSpecifyAppList(Long skinId);

    /**
     * 添加app定向
     * @param skinId
     * @param appId
     * @return
     */
    public DubboResult<Boolean> addAppSpecify(Long skinId,Long appId);

    /**
     * 切换显示状态
     * @param skinId
     * @return
     */
    public DubboResult<Integer> switchOpenState(Long skinId, Boolean isOpen);

    /**
     * 开发者加载皮肤列表
     * 勾选的皮肤对象中会多一个 selected:true
     * @param appId
     * @return [{id:id,name:皮肤名称,floorType:皮肤类型,image:展示图},...]
     */
    public DubboResult<List<JSONObject>> loadDevSkinList(Long appId);





}
