package cn.com.duiba.developer.center.api.remoteservice.floor;

import cn.com.duiba.developer.center.api.domain.dto.FloorShowcaseContentDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 
 * 楼层橱窗<br/>
 * Author：zhengjy<br/>
 * Create Time：2016年10月14日 上午10:22:27
 */
public interface RemoteShowcaseBackendService {
	/**
     * 根据appId和对应橱窗位编号查询橱窗位内容
     *
     * @param appId 应用ID
     * @param place 橱窗位编号
     * @return
     */
    DubboResult<FloorShowcaseContentDto> getShowcaseContent(long appId, int place);
    
    /**
     * 删除橱窗位的内容
     *
     * @param appId 应用ID
     * @param place 橱窗位编号
     * @return
     */
    DubboResult<Void> deleteShowcaseContent(long appId, int place);
 
    /**
     * 保存橱窗位的内容
     *
     * @param appId 应用ID
     * @param place 橱窗位编号
     * @return
     */
    DubboResult<Void> saveShowcaseContent(FloorShowcaseContentDto floorShowcaseContentDto);
 
    /**
     * 打开/关闭橱窗位倒计时
     *
     * @param appId 应用ID
     * @param place 橱窗位编号
     * @param enable true-开启，false-关闭
     * @return
     */
    DubboResult<Void> switchCountDown(long appId, int place, boolean enable);
}
