package cn.com.duiba.developer.center.api.remoteservice.floor;

import java.util.List;

import cn.com.duiba.developer.center.api.domain.dto.FloorShowcaseContentDto;
import cn.com.duiba.developer.center.api.domain.dto.ShowcaseDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 楼层橱窗手机端
 *<br/>
 * Author：zhengjy <br/>
 * Create Time：2016年10月17日 上午9:29:16
 */
public interface RemoteShowcaseService {
	/**
	 * 查询橱窗列表
	 * @param appId
	 * @return
	 */
	DubboResult<List<FloorShowcaseContentDto>> getShowcaseList(long appId);

	/**
	 * 保存橱窗配置
	 * @param showcaseDto
	 * @return
     */
	DubboResult<Boolean> saveShowcaseConfig(ShowcaseDto showcaseDto);

	/**
	 * 删除橱窗位
	 * @param appId
	 * @param place
     * @return
     */
	DubboResult<Boolean> delShowcaseConfig(Long appId,Integer place);
}
