/**
 * Project Name:developer-center-api File Name:SubPageTargetEnum.java Package
 * Name:cn.com.duiba.developer.center.api.domain.enums Date:2016年8月19日下午4:29:49 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.developer.center.api.domain.enums;

import org.apache.commons.lang.StringUtils;

/**
 * ClassName:ChildPageTargetEnum <br/>
 * 楼层配置枚举-点击后跳转目标 <br/>
 * Date: 2016年8月19日 下午4:29:49 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public enum ChildPageTargetEnum implements EnumInterface {
    GO_TO_SUB_PAGE("childPage", "点击后跳转到活动中心页面"),

    GO_TO_DETAIL("detail", "点击后跳转到详情页面");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private ChildPageTargetEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ChildPageTargetEnum getByCode(String code) {
        for (ChildPageTargetEnum enumVal : ChildPageTargetEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }
}
