/**
 * Project Name:activity-cms-web File Name:IconListTypeEnum.java Package Name:com.duiba.activity.cmsweb.enums
 * Date:2016年8月12日下午2:00:16 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.developer.center.api.domain.enums;

import org.apache.commons.lang.StringUtils;

import cn.com.duiba.dcommons.enums.AppBannerSourceTypeEnum;

/**
 * ClassName:IconListTypeEnum <br/>
 * 指向列表图标分类 <br/>
 * Date: 2016年8月12日 下午2:00:16 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public enum IconListTypeEnum implements EnumInterface {
    /** ==============自定义类型============== */
    ICON_CLASSIFY("classify", "指向自定义分类列表", "自定义分类", "自定义分类", "", AppBannerSourceTypeEnum.SourceTypeList.getCode()),

    /** ==============活动类型============== */
    ICON_ACTIVITY("activity", "指向活动分类列表", "活动", "活动", "http://yun.duiba.com.cn/developer/img/activity.jpg", 43),

    ICON_DRAW("draw", "指向抽奖列表", "抽奖", "抽奖", "http://yun.duiba.com.cn/developer/img/draw.jpg", 44),

    ICON_GAME("game", "指向游戏列表", "游戏", "游戏", "http://yun.duiba.com.cn/developer/img/game.jpg", 45),

    ICON_PLATFORM("platform", "指向券库列表", "领券", "领券", "http://yun.duiba.com.cn/developer/img/platform.jpg", 46),
    
    ICON_ACTIVITY_ROB("activytyRob", "指向今日必抢列表", "今日必抢", "今日必抢", "http://yun.duiba.com.cn/webapp/img/100-100.png", 47),

    /** ==============兑吧自定义类型============== */
    ICON_ALL("all", "指向所有商品列表", "所有商品", "所有商品", "http://yun.duiba.com.cn/img/icon_all.png", AppBannerSourceTypeEnum.SourceTypeList.getCode()),

    ICON_COST("cost", "指向直充类列表", "直充类", "直充类", "http://yun.duiba.com.cn/img/icon_charge.png", AppBannerSourceTypeEnum.SourceTypeList.getCode()),

    ICON_COUPON("coupon", "指向优惠券列表", "优惠券", "优惠券", "http://yun.duiba.com.cn/img/icon_coupon.png", AppBannerSourceTypeEnum.SourceTypeList.getCode()),

    ICON_OBJECT("object", "指向实物列表", "实物", "实物", "http://yun.duiba.com.cn/img/icon_object.png", AppBannerSourceTypeEnum.SourceTypeList.getCode()),

    ICON_LOTTERY("lottery", "指向抽奖活动列表", "抽奖活动", "抽奖活动", "http://yun.duiba.com.cn/img/icon_lottery.png", AppBannerSourceTypeEnum.SourceTypeList.getCode()),

    ICON_RECORDS("records", "指向兑换记录列表", "兑换记录", "兑换记录", "http://yun.duiba.com.cn/img/icon_record.png", AppBannerSourceTypeEnum.SourceTypeList.getCode());

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    /** 标题 */
    private String title;

    /** 指向目标 */
    private String target;

    /** 图片地址 */
    private String img;
    
    /** 来源类型 */
    private Integer sourceType;

    private IconListTypeEnum(String code, String desc, String title, String target, String img, Integer sourceType) {
        this.code = code;
        this.desc = desc;
        this.title = title;
        this.target = target;
        this.img = img;
        this.sourceType = sourceType;
    }

    public static IconListTypeEnum getByCode(String code) {
        for (IconListTypeEnum enumVal : IconListTypeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    public String getTitle() {
        return title;
    }

    public String getTarget() {
        return target;
    }

    public String getImg() {
        return img;
    }
    
    public Integer getSourceType() {
        return sourceType;
    }
    
}
