/**
 * Project Name:duiba-manager-common File Name:PushScourceTypeEnum.java Package
 * Name:cn.com.duiba.manager.web.common.enums Date:2016年11月2日下午8:14:11 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.developer.center.api.domain.enums;

import org.apache.commons.lang.StringUtils;


/**
 * 计划任务推送内容类
 * Date: 2016年11月2日 下午8:14:11 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public enum PushSourceTypeEnum implements EnumInterface {
    ITEM("item", false, "商品"),

    URL("url", false, "自定义链接"),

    SINGLE_LOTTERY("singleLottery", true, "单品抽奖"),

    TURNTABLE("turntable", true, "幸运大转盘"),

    HD_TOOL("hdtool", true, "活动工具"),

    OLD_GAME("oldGame", true, "兑吧游戏"),

    NEW_GAME("ngame", true, "游戏"),

    QUIZZ("quizz", true, "测试题"),

    GUESS("guess", true, "竞猜"),

    QUESTION_ANSWER("questionAnswer", true, "答题活动");

    /** 代码 */
    private String code;
    
    /** 是否活动类型 */
    private boolean isActivity;

    /** 描述 */
    private String desc;

    private PushSourceTypeEnum(String code, boolean isActivity, String desc) {
        this.code = code;
        this.isActivity = isActivity;
        this.desc = desc;
    }

    public static PushSourceTypeEnum getByCode(String code) {
        for (PushSourceTypeEnum enumVal : PushSourceTypeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    public boolean isActivity() {
        return isActivity;
    }
}
